/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.reactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.reactions.ReactionType;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class ReactionTypeCustomEmoji
implements ReactionType {
    private static final String TYPE_FIELD = "type";
    private static final String CUSTOM_EMOJI_ID_FIELD = "custom_emoji_id";
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="custom_emoji_id")
    @NonNull
    private String customEmojiId;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.customEmojiId.isEmpty()) {
            throw new TelegramApiValidationException("CustomEmojiId parameter can't be empty", this);
        }
        if (!"custom_emoji".equals(this.type)) {
            throw new TelegramApiValidationException("Type must be \"custom_emoji\"", this);
        }
    }

    private static String $default$type() {
        return "custom_emoji";
    }

    public static ReactionTypeCustomEmojiBuilder builder() {
        return new ReactionTypeCustomEmojiBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactionTypeCustomEmoji)) {
            return false;
        }
        ReactionTypeCustomEmoji other = (ReactionTypeCustomEmoji)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$customEmojiId = this.getCustomEmojiId();
        String other$customEmojiId = other.getCustomEmojiId();
        return !(this$customEmojiId == null ? other$customEmojiId != null : !this$customEmojiId.equals(other$customEmojiId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReactionTypeCustomEmoji;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $customEmojiId = this.getCustomEmojiId();
        result = result * 59 + ($customEmojiId == null ? 43 : $customEmojiId.hashCode());
        return result;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getCustomEmojiId() {
        return this.customEmojiId;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="custom_emoji_id")
    public void setCustomEmojiId(@NonNull String customEmojiId) {
        if (customEmojiId == null) {
            throw new NullPointerException("customEmojiId is marked non-null but is null");
        }
        this.customEmojiId = customEmojiId;
    }

    public String toString() {
        return "ReactionTypeCustomEmoji(type=" + this.getType() + ", customEmojiId=" + this.getCustomEmojiId() + ")";
    }

    public ReactionTypeCustomEmoji() {
        this.type = ReactionTypeCustomEmoji.$default$type();
    }

    public ReactionTypeCustomEmoji(@NonNull String type, @NonNull String customEmojiId) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (customEmojiId == null) {
            throw new NullPointerException("customEmojiId is marked non-null but is null");
        }
        this.type = type;
        this.customEmojiId = customEmojiId;
    }

    public static class ReactionTypeCustomEmojiBuilder {
        private boolean type$set;
        private String type$value;
        private String customEmojiId;

        ReactionTypeCustomEmojiBuilder() {
        }

        @JsonProperty(value="type")
        public ReactionTypeCustomEmojiBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @JsonProperty(value="custom_emoji_id")
        public ReactionTypeCustomEmojiBuilder customEmojiId(@NonNull String customEmojiId) {
            if (customEmojiId == null) {
                throw new NullPointerException("customEmojiId is marked non-null but is null");
            }
            this.customEmojiId = customEmojiId;
            return this;
        }

        public ReactionTypeCustomEmoji build() {
            String type$value = this.type$value;
            if (!this.type$set) {
                type$value = ReactionTypeCustomEmoji.$default$type();
            }
            return new ReactionTypeCustomEmoji(type$value, this.customEmojiId);
        }

        public String toString() {
            return "ReactionTypeCustomEmoji.ReactionTypeCustomEmojiBuilder(type$value=" + this.type$value + ", customEmojiId=" + this.customEmojiId + ")";
        }
    }
}

