/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.MessageId;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=ForwardMessagesBuilderImpl.class)
public class ForwardMessages
extends BotApiMethod<ArrayList<MessageId>> {
    public static final String PATH = "forwardMessages";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String FROM_CHAT_ID_FIELD = "from_chat_id";
    private static final String MESSAGE_IDS_FIELD = "message_ids";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="from_chat_id")
    @NonNull
    private String fromChatId;
    @JsonProperty(value="message_ids")
    @NonNull
    private List<Integer> messageIds;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void setFromChatId(@NonNull Long fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId.toString();
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.fromChatId.isEmpty()) {
            throw new TelegramApiValidationException("FromChatId can't be empty", this);
        }
        if (this.messageIds.isEmpty() || this.messageIds.size() > 100) {
            throw new TelegramApiValidationException("MessageIds parameter items count must be between 1 and 100", this);
        }
    }

    @Override
    public ArrayList<MessageId> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, MessageId.class);
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    protected ForwardMessages(ForwardMessagesBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.fromChatId = b.fromChatId;
        if (this.fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        List<Object> messageIds = switch (b.messageIds == null ? 0 : b.messageIds.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.messageIds.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Integer>(b.messageIds));
        };
        this.messageIds = messageIds;
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.disableNotification = b.disableNotification;
        this.protectContent = b.protectContent;
    }

    public static ForwardMessagesBuilder<?, ?> builder() {
        return new ForwardMessagesBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForwardMessages)) {
            return false;
        }
        ForwardMessages other = (ForwardMessages)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$fromChatId = this.getFromChatId();
        String other$fromChatId = other.getFromChatId();
        if (this$fromChatId == null ? other$fromChatId != null : !this$fromChatId.equals(other$fromChatId)) {
            return false;
        }
        List<Integer> this$messageIds = this.getMessageIds();
        List<Integer> other$messageIds = other.getMessageIds();
        return !(this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ForwardMessages;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $fromChatId = this.getFromChatId();
        result = result * 59 + ($fromChatId == null ? 43 : $fromChatId.hashCode());
        List<Integer> $messageIds = this.getMessageIds();
        result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public String getFromChatId() {
        return this.fromChatId;
    }

    @NonNull
    public List<Integer> getMessageIds() {
        return this.messageIds;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="from_chat_id")
    public void setFromChatId(@NonNull String fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId;
    }

    @JsonProperty(value="message_ids")
    public void setMessageIds(@NonNull List<Integer> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.messageIds = messageIds;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="protect_content")
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public String toString() {
        return "ForwardMessages(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", fromChatId=" + this.getFromChatId() + ", messageIds=" + this.getMessageIds() + ", disableNotification=" + this.getDisableNotification() + ", protectContent=" + this.getProtectContent() + ")";
    }

    public ForwardMessages(@NonNull String chatId, @NonNull String fromChatId, @NonNull List<Integer> messageIds) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.chatId = chatId;
        this.fromChatId = fromChatId;
        this.messageIds = messageIds;
    }

    public ForwardMessages(@NonNull String chatId, Integer messageThreadId, @NonNull String fromChatId, @NonNull List<Integer> messageIds, Boolean disableNotification, Boolean protectContent) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.fromChatId = fromChatId;
        this.messageIds = messageIds;
        this.disableNotification = disableNotification;
        this.protectContent = protectContent;
    }

    public static abstract class ForwardMessagesBuilder<C extends ForwardMessages, B extends ForwardMessagesBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<ArrayList<MessageId>, C, B> {
        private String chatId;
        private Integer messageThreadId;
        private String fromChatId;
        private ArrayList<Integer> messageIds;
        private Boolean disableNotification;
        private Boolean protectContent;

        public ForwardMessagesBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public ForwardMessagesBuilder<C, B> fromChatId(@NonNull Long fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="from_chat_id")
        public B fromChatId(@NonNull String fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId;
            return (B)this.self();
        }

        public B messageId(Integer messageId) {
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.add(messageId);
            return (B)this.self();
        }

        @JsonProperty(value="message_ids")
        public B messageIds(Collection<? extends Integer> messageIds) {
            if (messageIds == null) {
                throw new NullPointerException("messageIds cannot be null");
            }
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.addAll(messageIds);
            return (B)this.self();
        }

        public B clearMessageIds() {
            if (this.messageIds != null) {
                this.messageIds.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ForwardMessages.ForwardMessagesBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", fromChatId=" + this.fromChatId + ", messageIds=" + this.messageIds + ", disableNotification=" + this.disableNotification + ", protectContent=" + this.protectContent + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class ForwardMessagesBuilderImpl
    extends ForwardMessagesBuilder<ForwardMessages, ForwardMessagesBuilderImpl> {
        private ForwardMessagesBuilderImpl() {
        }

        @Override
        protected ForwardMessagesBuilderImpl self() {
            return this;
        }

        @Override
        public ForwardMessages build() {
            return new ForwardMessages(this);
        }
    }
}

