/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.commands.BotCommand;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScope;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=SetMyCommandsBuilderImpl.class)
public class SetMyCommands
extends BotApiMethodBoolean {
    public static final String PATH = "setMyCommands";
    private static final String COMMANDS_FIELD = "commands";
    private static final String SCOPE_FIELD = "scope";
    private static final String LANGUAGECODE_FIELD = "language_code";
    @JsonProperty(value="commands")
    @NonNull
    private List<BotCommand> commands;
    @JsonProperty(value="scope")
    private BotCommandScope scope;
    @JsonProperty(value="language_code")
    private String languageCode;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.languageCode != null && this.languageCode.isEmpty()) {
            throw new TelegramApiValidationException("LanguageCode parameter can't be empty string", this);
        }
        if (this.commands.isEmpty()) {
            throw new TelegramApiValidationException("Commands parameter can't be empty", this);
        }
        if (this.commands.size() > 100) {
            throw new TelegramApiValidationException("No more than 100 commands are allowed", this);
        }
        for (BotCommand command : this.commands) {
            command.validate();
        }
        if (this.scope != null) {
            this.scope.validate();
        }
    }

    protected SetMyCommands(SetMyCommandsBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        List<Object> commands = switch (b.commands == null ? 0 : b.commands.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.commands.get(0));
            default -> Collections.unmodifiableList(new ArrayList<BotCommand>(b.commands));
        };
        this.commands = commands;
        if (commands == null) {
            throw new NullPointerException("commands is marked non-null but is null");
        }
        this.scope = b.scope;
        this.languageCode = b.languageCode;
    }

    public static SetMyCommandsBuilder<?, ?> builder() {
        return new SetMyCommandsBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetMyCommands)) {
            return false;
        }
        SetMyCommands other = (SetMyCommands)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BotCommand> this$commands = this.getCommands();
        List<BotCommand> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        BotCommandScope this$scope = this.getScope();
        BotCommandScope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$languageCode = this.getLanguageCode();
        String other$languageCode = other.getLanguageCode();
        return !(this$languageCode == null ? other$languageCode != null : !this$languageCode.equals(other$languageCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetMyCommands;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BotCommand> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        BotCommandScope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $languageCode = this.getLanguageCode();
        result = result * 59 + ($languageCode == null ? 43 : $languageCode.hashCode());
        return result;
    }

    @NonNull
    public List<BotCommand> getCommands() {
        return this.commands;
    }

    public BotCommandScope getScope() {
        return this.scope;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    @JsonProperty(value="commands")
    public void setCommands(@NonNull List<BotCommand> commands) {
        if (commands == null) {
            throw new NullPointerException("commands is marked non-null but is null");
        }
        this.commands = commands;
    }

    @JsonProperty(value="scope")
    public void setScope(BotCommandScope scope) {
        this.scope = scope;
    }

    @JsonProperty(value="language_code")
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String toString() {
        return "SetMyCommands(commands=" + this.getCommands() + ", scope=" + this.getScope() + ", languageCode=" + this.getLanguageCode() + ")";
    }

    public SetMyCommands(@NonNull List<BotCommand> commands) {
        if (commands == null) {
            throw new NullPointerException("commands is marked non-null but is null");
        }
        this.commands = commands;
    }

    public SetMyCommands(@NonNull List<BotCommand> commands, BotCommandScope scope, String languageCode) {
        if (commands == null) {
            throw new NullPointerException("commands is marked non-null but is null");
        }
        this.commands = commands;
        this.scope = scope;
        this.languageCode = languageCode;
    }

    public static abstract class SetMyCommandsBuilder<C extends SetMyCommands, B extends SetMyCommandsBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        private ArrayList<BotCommand> commands;
        private BotCommandScope scope;
        private String languageCode;

        public B command(BotCommand command) {
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.add(command);
            return (B)this.self();
        }

        @JsonProperty(value="commands")
        public B commands(Collection<? extends BotCommand> commands) {
            if (commands == null) {
                throw new NullPointerException("commands cannot be null");
            }
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.addAll(commands);
            return (B)this.self();
        }

        public B clearCommands() {
            if (this.commands != null) {
                this.commands.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="scope")
        public B scope(BotCommandScope scope) {
            this.scope = scope;
            return (B)this.self();
        }

        @JsonProperty(value="language_code")
        public B languageCode(String languageCode) {
            this.languageCode = languageCode;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SetMyCommands.SetMyCommandsBuilder(super=" + super.toString() + ", commands=" + this.commands + ", scope=" + this.scope + ", languageCode=" + this.languageCode + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SetMyCommandsBuilderImpl
    extends SetMyCommandsBuilder<SetMyCommands, SetMyCommandsBuilderImpl> {
        private SetMyCommandsBuilderImpl() {
        }

        @Override
        protected SetMyCommandsBuilderImpl self() {
            return this;
        }

        @Override
        public SetMyCommands build() {
            return new SetMyCommands(this);
        }
    }
}

