/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.forum;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=DeleteForumTopicBuilderImpl.class)
public class DeleteForumTopic
extends BotApiMethodBoolean {
    public static final String PATH = "deleteForumTopic";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGETHREADID_FIELD = "message_thread_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    @NonNull
    private Integer messageThreadId;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.messageThreadId <= 0) {
            throw new TelegramApiValidationException("Message Thread Id can't be empty", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    protected DeleteForumTopic(DeleteForumTopicBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        if (this.messageThreadId == null) {
            throw new NullPointerException("messageThreadId is marked non-null but is null");
        }
    }

    public static DeleteForumTopicBuilder<?, ?> builder() {
        return new DeleteForumTopicBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteForumTopic)) {
            return false;
        }
        DeleteForumTopic other = (DeleteForumTopic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteForumTopic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    public void setMessageThreadId(@NonNull Integer messageThreadId) {
        if (messageThreadId == null) {
            throw new NullPointerException("messageThreadId is marked non-null but is null");
        }
        this.messageThreadId = messageThreadId;
    }

    public String toString() {
        return "DeleteForumTopic(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ")";
    }

    public DeleteForumTopic(@NonNull String chatId, @NonNull Integer messageThreadId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageThreadId == null) {
            throw new NullPointerException("messageThreadId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
    }

    public static abstract class DeleteForumTopicBuilder<C extends DeleteForumTopic, B extends DeleteForumTopicBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        private String chatId;
        private Integer messageThreadId;

        public DeleteForumTopicBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        public B messageThreadId(@NonNull Integer messageThreadId) {
            if (messageThreadId == null) {
                throw new NullPointerException("messageThreadId is marked non-null but is null");
            }
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DeleteForumTopic.DeleteForumTopicBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class DeleteForumTopicBuilderImpl
    extends DeleteForumTopicBuilder<DeleteForumTopic, DeleteForumTopicBuilderImpl> {
        private DeleteForumTopicBuilderImpl() {
        }

        @Override
        protected DeleteForumTopicBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteForumTopic build() {
            return new DeleteForumTopic(this);
        }
    }
}

