/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.games;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.games.GameHighScore;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=GetGameHighScoresBuilderImpl.class)
public class GetGameHighScores
extends BotApiMethod<ArrayList<GameHighScore>> {
    public static final String PATH = "getGameHighScores";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String USER_ID_FIELD = "user_id";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;

    public void setChatId(Long chatId) {
        this.chatId = chatId == null ? null : chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ArrayList<GameHighScore> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, GameHighScore.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null || this.chatId.isEmpty()) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
    }

    protected GetGameHighScores(GetGameHighScoresBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        this.messageId = b.messageId;
        this.inlineMessageId = b.inlineMessageId;
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
    }

    public static GetGameHighScoresBuilder<?, ?> builder() {
        return new GetGameHighScoresBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetGameHighScores)) {
            return false;
        }
        GetGameHighScores other = (GetGameHighScores)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        return !(this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetGameHighScores;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        return result;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public String toString() {
        return "GetGameHighScores(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", userId=" + this.getUserId() + ")";
    }

    public GetGameHighScores(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public GetGameHighScores(String chatId, Integer messageId, String inlineMessageId, @NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.userId = userId;
    }

    public static abstract class GetGameHighScoresBuilder<C extends GetGameHighScores, B extends GetGameHighScoresBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<ArrayList<GameHighScore>, C, B> {
        private String chatId;
        private Integer messageId;
        private String inlineMessageId;
        private Long userId;

        public GetGameHighScoresBuilder<C, B> chatId(Long chatId) {
            this.chatId = chatId == null ? null : chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(String chatId) {
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        public B messageId(Integer messageId) {
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="inline_message_id")
        public B inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="user_id")
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "GetGameHighScores.GetGameHighScoresBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", userId=" + this.userId + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class GetGameHighScoresBuilderImpl
    extends GetGameHighScoresBuilder<GetGameHighScores, GetGameHighScoresBuilderImpl> {
        private GetGameHighScoresBuilderImpl() {
        }

        @Override
        protected GetGameHighScoresBuilderImpl self() {
            return this;
        }

        @Override
        public GetGameHighScores build() {
            return new GetGameHighScores(this);
        }
    }
}

