/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=BanChatMemberBuilderImpl.class)
public class BanChatMember
extends BotApiMethodBoolean {
    public static final String PATH = "banChatMember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    private static final String UNTILDATE_FIELD = "until_date";
    private static final String REVOKEMESSAGES_FIELD = "revoke_messages";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="until_date")
    private Integer untilDate;
    @JsonProperty(value="revoke_messages")
    private Boolean revokeMessages;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @JsonIgnore
    public void setUntilDateInstant(Instant instant) {
        this.setUntilDate((int)instant.getEpochSecond());
    }

    @JsonIgnore
    public void setUntilDateDateTime(ZonedDateTime date) {
        this.setUntilDateInstant(date.toInstant());
    }

    @JsonIgnore
    public void forTimePeriodDuration(Duration duration) {
        this.setUntilDateInstant(Instant.now().plusMillis(duration.toMillis()));
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == 0L) {
            throw new TelegramApiValidationException("UserId can't be null or 0", this);
        }
    }

    protected BanChatMember(BanChatMemberBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.untilDate = b.untilDate;
        this.revokeMessages = b.revokeMessages;
    }

    public static BanChatMemberBuilder<?, ?> builder() {
        return new BanChatMemberBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BanChatMember)) {
            return false;
        }
        BanChatMember other = (BanChatMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$untilDate = this.getUntilDate();
        Integer other$untilDate = other.getUntilDate();
        if (this$untilDate == null ? other$untilDate != null : !((Object)this$untilDate).equals(other$untilDate)) {
            return false;
        }
        Boolean this$revokeMessages = this.getRevokeMessages();
        Boolean other$revokeMessages = other.getRevokeMessages();
        if (this$revokeMessages == null ? other$revokeMessages != null : !((Object)this$revokeMessages).equals(other$revokeMessages)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BanChatMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : ((Object)$untilDate).hashCode());
        Boolean $revokeMessages = this.getRevokeMessages();
        result = result * 59 + ($revokeMessages == null ? 43 : ((Object)$revokeMessages).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    public Integer getUntilDate() {
        return this.untilDate;
    }

    public Boolean getRevokeMessages() {
        return this.revokeMessages;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="until_date")
    public void setUntilDate(Integer untilDate) {
        this.untilDate = untilDate;
    }

    @JsonProperty(value="revoke_messages")
    public void setRevokeMessages(Boolean revokeMessages) {
        this.revokeMessages = revokeMessages;
    }

    public String toString() {
        return "BanChatMember(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ", untilDate=" + this.getUntilDate() + ", revokeMessages=" + this.getRevokeMessages() + ")";
    }

    public BanChatMember(@NonNull String chatId, @NonNull Long userId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
    }

    public BanChatMember(@NonNull String chatId, @NonNull Long userId, Integer untilDate, Boolean revokeMessages) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.untilDate = untilDate;
        this.revokeMessages = revokeMessages;
    }

    public static abstract class BanChatMemberBuilder<C extends BanChatMember, B extends BanChatMemberBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        private String chatId;
        private Long userId;
        private Integer untilDate;
        private Boolean revokeMessages;

        public BanChatMemberBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="user_id")
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @JsonProperty(value="until_date")
        public B untilDate(Integer untilDate) {
            this.untilDate = untilDate;
            return (B)this.self();
        }

        @JsonProperty(value="revoke_messages")
        public B revokeMessages(Boolean revokeMessages) {
            this.revokeMessages = revokeMessages;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BanChatMember.BanChatMemberBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", userId=" + this.userId + ", untilDate=" + this.untilDate + ", revokeMessages=" + this.revokeMessages + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class BanChatMemberBuilderImpl
    extends BanChatMemberBuilder<BanChatMember, BanChatMemberBuilderImpl> {
        private BanChatMemberBuilderImpl() {
        }

        @Override
        protected BanChatMemberBuilderImpl self() {
            return this;
        }

        @Override
        public BanChatMember build() {
            return new BanChatMember(this);
        }
    }
}

