/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Chat;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=GetChatBuilderImpl.class)
public class GetChat
extends BotApiMethod<Chat> {
    public static final String PATH = "getChat";
    private static final String CHATID_FIELD = "chat_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;

    @Override
    public String getMethod() {
        return PATH;
    }

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public Chat deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Chat.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
    }

    protected GetChat(GetChatBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
    }

    public static GetChatBuilder<?, ?> builder() {
        return new GetChatBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetChat)) {
            return false;
        }
        GetChat other = (GetChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetChat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public String toString() {
        return "GetChat(chatId=" + this.getChatId() + ")";
    }

    public GetChat(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public static abstract class GetChatBuilder<C extends GetChat, B extends GetChatBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<Chat, C, B> {
        private String chatId;

        public GetChatBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "GetChat.GetChatBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class GetChatBuilderImpl
    extends GetChatBuilder<GetChat, GetChatBuilderImpl> {
        private GetChatBuilderImpl() {
        }

        @Override
        protected GetChatBuilderImpl self() {
            return this;
        }

        @Override
        public GetChat build() {
            return new GetChat(this);
        }
    }
}

