/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=SetChatPhotoBuilderImpl.class)
public class SetChatPhoto
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "setChatPhoto";
    public static final String CHATID_FIELD = "chat_id";
    public static final String PHOTO_FIELD = "photo";
    @NonNull
    private String chatId;
    @NonNull
    private InputFile photo;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (!this.photo.isNew()) {
            throw new TelegramApiValidationException("Photo parameter is required and must be a new file to upload", this);
        }
    }

    protected SetChatPhoto(SetChatPhotoBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.photo = b.photo;
        if (this.photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
    }

    public static SetChatPhotoBuilder<?, ?> builder() {
        return new SetChatPhotoBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetChatPhoto)) {
            return false;
        }
        SetChatPhoto other = (SetChatPhoto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputFile this$photo = this.getPhoto();
        InputFile other$photo = other.getPhoto();
        return !(this$photo == null ? other$photo != null : !((Object)this$photo).equals(other$photo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetChatPhoto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputFile $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : ((Object)$photo).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public InputFile getPhoto() {
        return this.photo;
    }

    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public void setPhoto(@NonNull InputFile photo) {
        if (photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
        this.photo = photo;
    }

    public String toString() {
        return "SetChatPhoto(chatId=" + this.getChatId() + ", photo=" + this.getPhoto() + ")";
    }

    public SetChatPhoto(@NonNull String chatId, @NonNull InputFile photo) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
        this.chatId = chatId;
        this.photo = photo;
    }

    public static abstract class SetChatPhotoBuilder<C extends SetChatPhoto, B extends SetChatPhotoBuilder<C, B>>
    extends PartialBotApiMethod.PartialBotApiMethodBuilder<Boolean, C, B> {
        private String chatId;
        private InputFile photo;

        public SetChatPhotoBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        public B photo(@NonNull InputFile photo) {
            if (photo == null) {
                throw new NullPointerException("photo is marked non-null but is null");
            }
            this.photo = photo;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SetChatPhoto.SetChatPhotoBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", photo=" + this.photo + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SetChatPhotoBuilderImpl
    extends SetChatPhotoBuilder<SetChatPhoto, SetChatPhotoBuilderImpl> {
        private SetChatPhotoBuilderImpl() {
        }

        @Override
        protected SetChatPhotoBuilderImpl self() {
            return this;
        }

        @Override
        public SetChatPhoto build() {
            return new SetChatPhoto(this);
        }
    }
}

