/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaBotMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=SendDocumentBuilderImpl.class)
public class SendDocument
extends SendMediaBotMethod<Message> {
    public static final String PATH = "senddocument";
    public static final String DOCUMENT_FIELD = "document";
    public static final String CAPTION_FIELD = "caption";
    public static final String PARSEMODE_FIELD = "parse_mode";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    public static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    public static final String DISABLECONTENTTYPEDETECTION_FIELD = "disable_content_type_detection";
    @NonNull
    private String chatId;
    private Integer messageThreadId;
    @NonNull
    private InputFile document;
    private String caption;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private String parseMode;
    private InputFile thumbnail;
    private List<MessageEntity> captionEntities;
    private Boolean allowSendingWithoutReply;
    private Boolean disableContentTypeDetection;
    private Boolean protectContent;
    private ReplyParameters replyParameters;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        this.document.validate();
        if (this.thumbnail != null) {
            this.thumbnail.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Override
    public InputFile getFile() {
        return this.document;
    }

    @Override
    public String getFileField() {
        return DOCUMENT_FIELD;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    protected SendDocument(SendDocumentBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.document = b.document;
        if (this.document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.caption = b.caption;
        this.disableNotification = b.disableNotification;
        this.replyToMessageId = b.replyToMessageId;
        this.replyMarkup = b.replyMarkup;
        this.parseMode = b.parseMode;
        this.thumbnail = b.thumbnail;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.disableContentTypeDetection = b.disableContentTypeDetection;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
    }

    public static SendDocumentBuilder<?, ?> builder() {
        return new SendDocumentBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendDocument)) {
            return false;
        }
        SendDocument other = (SendDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$disableContentTypeDetection = this.getDisableContentTypeDetection();
        Boolean other$disableContentTypeDetection = other.getDisableContentTypeDetection();
        if (this$disableContentTypeDetection == null ? other$disableContentTypeDetection != null : !((Object)this$disableContentTypeDetection).equals(other$disableContentTypeDetection)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputFile this$document = this.getDocument();
        InputFile other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        return !(this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $disableContentTypeDetection = this.getDisableContentTypeDetection();
        result = result * 59 + ($disableContentTypeDetection == null ? 43 : ((Object)$disableContentTypeDetection).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputFile $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        return result;
    }

    @Override
    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @Override
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public InputFile getDocument() {
        return this.document;
    }

    public String getCaption() {
        return this.caption;
    }

    @Override
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Override
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Override
    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Override
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public Boolean getDisableContentTypeDetection() {
        return this.disableContentTypeDetection;
    }

    @Override
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Override
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    public void setDocument(@NonNull InputFile document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.document = document;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    public void setDisableContentTypeDetection(Boolean disableContentTypeDetection) {
        this.disableContentTypeDetection = disableContentTypeDetection;
    }

    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    public String toString() {
        return "SendDocument(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", document=" + this.getDocument() + ", caption=" + this.getCaption() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", thumbnail=" + this.getThumbnail() + ", captionEntities=" + this.getCaptionEntities() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", disableContentTypeDetection=" + this.getDisableContentTypeDetection() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ")";
    }

    public SendDocument(@NonNull String chatId, @NonNull InputFile document) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.chatId = chatId;
        this.document = document;
    }

    public SendDocument(@NonNull String chatId, Integer messageThreadId, @NonNull InputFile document, String caption, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, String parseMode, InputFile thumbnail, List<MessageEntity> captionEntities, Boolean allowSendingWithoutReply, Boolean disableContentTypeDetection, Boolean protectContent, ReplyParameters replyParameters) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.document = document;
        this.caption = caption;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.thumbnail = thumbnail;
        this.captionEntities = captionEntities;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.disableContentTypeDetection = disableContentTypeDetection;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
    }

    public static abstract class SendDocumentBuilder<C extends SendDocument, B extends SendDocumentBuilder<C, B>>
    extends SendMediaBotMethod.SendMediaBotMethodBuilder<Message, C, B> {
        private String chatId;
        private Integer messageThreadId;
        private InputFile document;
        private String caption;
        private Boolean disableNotification;
        private Integer replyToMessageId;
        private ReplyKeyboard replyMarkup;
        private String parseMode;
        private InputFile thumbnail;
        private ArrayList<MessageEntity> captionEntities;
        private Boolean allowSendingWithoutReply;
        private Boolean disableContentTypeDetection;
        private Boolean protectContent;
        private ReplyParameters replyParameters;

        public SendDocumentBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        public B document(@NonNull InputFile document) {
            if (document == null) {
                throw new NullPointerException("document is marked non-null but is null");
            }
            this.document = document;
            return (B)this.self();
        }

        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return (B)this.self();
        }

        public B thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return (B)this.self();
        }

        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return (B)this.self();
        }

        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return (B)this.self();
        }

        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        public B disableContentTypeDetection(Boolean disableContentTypeDetection) {
            this.disableContentTypeDetection = disableContentTypeDetection;
            return (B)this.self();
        }

        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SendDocument.SendDocumentBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", document=" + this.document + ", caption=" + this.caption + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", thumbnail=" + this.thumbnail + ", captionEntities=" + this.captionEntities + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", disableContentTypeDetection=" + this.disableContentTypeDetection + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SendDocumentBuilderImpl
    extends SendDocumentBuilder<SendDocument, SendDocumentBuilderImpl> {
        private SendDocumentBuilderImpl() {
        }

        @Override
        protected SendDocumentBuilderImpl self() {
            return this;
        }

        @Override
        public SendDocument build() {
            return new SendDocument(this);
        }
    }
}

