/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=SendVenueBuilderImpl.class)
public class SendVenue
extends BotApiMethodMessage {
    public static final String PATH = "sendVenue";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGETHREADID_FIELD = "message_thread_id";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String TITLE_FIELD = "title";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String ADDRESS_FIELD = "address";
    private static final String FOURSQUAREID_FIELD = "foursquare_id";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private static final String FOURSQUARETYPE_FIELD = "foursquare_type";
    private static final String ALLOWSENDINGWITHOUTREPLY_FIELD = "allow_sending_without_reply";
    private static final String GOOGLEPLACEID_FIELD = "google_place_id";
    private static final String GOOGLEPLACETYPE_FIELD = "google_place_type";
    private static final String PROTECTCONTENT_FIELD = "protect_content";
    private static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="latitude")
    @NonNull
    private Double latitude;
    @JsonProperty(value="longitude")
    @NonNull
    private Double longitude;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="address")
    @NonNull
    private String address;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="foursquare_id")
    private String foursquareId;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;
    @JsonProperty(value="foursquare_type")
    private String foursquareType;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="google_place_id")
    private String googlePlaceId;
    @JsonProperty(value="google_place_type")
    private String googlePlaceType;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="reply_parameters")
    private ReplyParameters replyParameters;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    protected SendVenue(SendVenueBuilder<?, ?> b) {
        super((BotApiMethodMessage.BotApiMethodMessageBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.latitude = b.latitude;
        if (this.latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.longitude = b.longitude;
        if (this.longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.title = b.title;
        if (this.title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.address = b.address;
        if (this.address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.disableNotification = b.disableNotification;
        this.foursquareId = b.foursquareId;
        this.replyToMessageId = b.replyToMessageId;
        this.replyMarkup = b.replyMarkup;
        this.foursquareType = b.foursquareType;
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.googlePlaceId = b.googlePlaceId;
        this.googlePlaceType = b.googlePlaceType;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
    }

    public static SendVenueBuilder<?, ?> builder() {
        return new SendVenueBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendVenue)) {
            return false;
        }
        SendVenue other = (SendVenue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$foursquareId = this.getFoursquareId();
        String other$foursquareId = other.getFoursquareId();
        if (this$foursquareId == null ? other$foursquareId != null : !this$foursquareId.equals(other$foursquareId)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$foursquareType = this.getFoursquareType();
        String other$foursquareType = other.getFoursquareType();
        if (this$foursquareType == null ? other$foursquareType != null : !this$foursquareType.equals(other$foursquareType)) {
            return false;
        }
        String this$googlePlaceId = this.getGooglePlaceId();
        String other$googlePlaceId = other.getGooglePlaceId();
        if (this$googlePlaceId == null ? other$googlePlaceId != null : !this$googlePlaceId.equals(other$googlePlaceId)) {
            return false;
        }
        String this$googlePlaceType = this.getGooglePlaceType();
        String other$googlePlaceType = other.getGooglePlaceType();
        if (this$googlePlaceType == null ? other$googlePlaceType != null : !this$googlePlaceType.equals(other$googlePlaceType)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        return !(this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendVenue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $foursquareId = this.getFoursquareId();
        result = result * 59 + ($foursquareId == null ? 43 : $foursquareId.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $foursquareType = this.getFoursquareType();
        result = result * 59 + ($foursquareType == null ? 43 : $foursquareType.hashCode());
        String $googlePlaceId = this.getGooglePlaceId();
        result = result * 59 + ($googlePlaceId == null ? 43 : $googlePlaceId.hashCode());
        String $googlePlaceType = this.getGooglePlaceType();
        result = result * 59 + ($googlePlaceType == null ? 43 : $googlePlaceType.hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public Double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public Double getLongitude() {
        return this.longitude;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getAddress() {
        return this.address;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public String getFoursquareId() {
        return this.foursquareId;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getFoursquareType() {
        return this.foursquareType;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public String getGooglePlaceId() {
        return this.googlePlaceId;
    }

    public String getGooglePlaceType() {
        return this.googlePlaceType;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(@NonNull Double latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(@NonNull Double longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="address")
    public void setAddress(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="foursquare_id")
    public void setFoursquareId(String foursquareId) {
        this.foursquareId = foursquareId;
    }

    @JsonProperty(value="reply_to_message_id")
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="foursquare_type")
    public void setFoursquareType(String foursquareType) {
        this.foursquareType = foursquareType;
    }

    @JsonProperty(value="allow_sending_without_reply")
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="google_place_id")
    public void setGooglePlaceId(String googlePlaceId) {
        this.googlePlaceId = googlePlaceId;
    }

    @JsonProperty(value="google_place_type")
    public void setGooglePlaceType(String googlePlaceType) {
        this.googlePlaceType = googlePlaceType;
    }

    @JsonProperty(value="protect_content")
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="reply_parameters")
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    public String toString() {
        return "SendVenue(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", title=" + this.getTitle() + ", address=" + this.getAddress() + ", disableNotification=" + this.getDisableNotification() + ", foursquareId=" + this.getFoursquareId() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", foursquareType=" + this.getFoursquareType() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", googlePlaceId=" + this.getGooglePlaceId() + ", googlePlaceType=" + this.getGooglePlaceType() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ")";
    }

    public SendVenue(@NonNull String chatId, @NonNull Double latitude, @NonNull Double longitude, @NonNull String title, @NonNull String address) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.chatId = chatId;
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.address = address;
    }

    public SendVenue(@NonNull String chatId, Integer messageThreadId, @NonNull Double latitude, @NonNull Double longitude, @NonNull String title, @NonNull String address, Boolean disableNotification, String foursquareId, Integer replyToMessageId, ReplyKeyboard replyMarkup, String foursquareType, Boolean allowSendingWithoutReply, String googlePlaceId, String googlePlaceType, Boolean protectContent, ReplyParameters replyParameters) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.address = address;
        this.disableNotification = disableNotification;
        this.foursquareId = foursquareId;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.foursquareType = foursquareType;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.googlePlaceId = googlePlaceId;
        this.googlePlaceType = googlePlaceType;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
    }

    public static abstract class SendVenueBuilder<C extends SendVenue, B extends SendVenueBuilder<C, B>>
    extends BotApiMethodMessage.BotApiMethodMessageBuilder<C, B> {
        private String chatId;
        private Integer messageThreadId;
        private Double latitude;
        private Double longitude;
        private String title;
        private String address;
        private Boolean disableNotification;
        private String foursquareId;
        private Integer replyToMessageId;
        private ReplyKeyboard replyMarkup;
        private String foursquareType;
        private Boolean allowSendingWithoutReply;
        private String googlePlaceId;
        private String googlePlaceType;
        private Boolean protectContent;
        private ReplyParameters replyParameters;

        public SendVenueBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="latitude")
        public B latitude(@NonNull Double latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return (B)this.self();
        }

        @JsonProperty(value="longitude")
        public B longitude(@NonNull Double longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return (B)this.self();
        }

        @JsonProperty(value="title")
        public B title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return (B)this.self();
        }

        @JsonProperty(value="address")
        public B address(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="foursquare_id")
        public B foursquareId(String foursquareId) {
            this.foursquareId = foursquareId;
            return (B)this.self();
        }

        @JsonProperty(value="reply_to_message_id")
        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="foursquare_type")
        public B foursquareType(String foursquareType) {
            this.foursquareType = foursquareType;
            return (B)this.self();
        }

        @JsonProperty(value="allow_sending_without_reply")
        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        @JsonProperty(value="google_place_id")
        public B googlePlaceId(String googlePlaceId) {
            this.googlePlaceId = googlePlaceId;
            return (B)this.self();
        }

        @JsonProperty(value="google_place_type")
        public B googlePlaceType(String googlePlaceType) {
            this.googlePlaceType = googlePlaceType;
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @JsonProperty(value="reply_parameters")
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SendVenue.SendVenueBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", title=" + this.title + ", address=" + this.address + ", disableNotification=" + this.disableNotification + ", foursquareId=" + this.foursquareId + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", foursquareType=" + this.foursquareType + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", googlePlaceId=" + this.googlePlaceId + ", googlePlaceType=" + this.googlePlaceType + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SendVenueBuilderImpl
    extends SendVenueBuilder<SendVenue, SendVenueBuilderImpl> {
        private SendVenueBuilderImpl() {
        }

        @Override
        protected SendVenueBuilderImpl self() {
            return this;
        }

        @Override
        public SendVenue build() {
            return new SendVenue(this);
        }
    }
}

