/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=LoginUrlBuilderImpl.class)
public class LoginUrl
implements Validable,
BotApiObject {
    private static final String URL_FIELD = "url";
    private static final String FORWARD_TEXT_FIELD = "forward_text";
    private static final String BOT_USERNAME_FIELD = "bot_username";
    private static final String REQUEST_WRITE_ACCESS_FIELD = "request_write_access";
    @JsonProperty(value="url")
    @NonNull
    private String url;
    @JsonProperty(value="forward_text")
    private String forwardText;
    @JsonProperty(value="bot_username")
    private String botUsername;
    @JsonProperty(value="request_write_access")
    private Boolean requestWriteAccess;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.url == null || this.url.isEmpty()) {
            throw new TelegramApiValidationException("Url parameter can't be empty", this);
        }
    }

    protected LoginUrl(LoginUrlBuilder<?, ?> b) {
        this.url = b.url;
        if (this.url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.forwardText = b.forwardText;
        this.botUsername = b.botUsername;
        this.requestWriteAccess = b.requestWriteAccess;
    }

    public static LoginUrlBuilder<?, ?> builder() {
        return new LoginUrlBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginUrl)) {
            return false;
        }
        LoginUrl other = (LoginUrl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$requestWriteAccess = this.getRequestWriteAccess();
        Boolean other$requestWriteAccess = other.getRequestWriteAccess();
        if (this$requestWriteAccess == null ? other$requestWriteAccess != null : !((Object)this$requestWriteAccess).equals(other$requestWriteAccess)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$forwardText = this.getForwardText();
        String other$forwardText = other.getForwardText();
        if (this$forwardText == null ? other$forwardText != null : !this$forwardText.equals(other$forwardText)) {
            return false;
        }
        String this$botUsername = this.getBotUsername();
        String other$botUsername = other.getBotUsername();
        return !(this$botUsername == null ? other$botUsername != null : !this$botUsername.equals(other$botUsername));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginUrl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $requestWriteAccess = this.getRequestWriteAccess();
        result = result * 59 + ($requestWriteAccess == null ? 43 : ((Object)$requestWriteAccess).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $forwardText = this.getForwardText();
        result = result * 59 + ($forwardText == null ? 43 : $forwardText.hashCode());
        String $botUsername = this.getBotUsername();
        result = result * 59 + ($botUsername == null ? 43 : $botUsername.hashCode());
        return result;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public String getForwardText() {
        return this.forwardText;
    }

    public String getBotUsername() {
        return this.botUsername;
    }

    public Boolean getRequestWriteAccess() {
        return this.requestWriteAccess;
    }

    @JsonProperty(value="url")
    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    @JsonProperty(value="forward_text")
    public void setForwardText(String forwardText) {
        this.forwardText = forwardText;
    }

    @JsonProperty(value="bot_username")
    public void setBotUsername(String botUsername) {
        this.botUsername = botUsername;
    }

    @JsonProperty(value="request_write_access")
    public void setRequestWriteAccess(Boolean requestWriteAccess) {
        this.requestWriteAccess = requestWriteAccess;
    }

    public String toString() {
        return "LoginUrl(url=" + this.getUrl() + ", forwardText=" + this.getForwardText() + ", botUsername=" + this.getBotUsername() + ", requestWriteAccess=" + this.getRequestWriteAccess() + ")";
    }

    public LoginUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public LoginUrl(@NonNull String url, String forwardText, String botUsername, Boolean requestWriteAccess) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
        this.forwardText = forwardText;
        this.botUsername = botUsername;
        this.requestWriteAccess = requestWriteAccess;
    }

    public static abstract class LoginUrlBuilder<C extends LoginUrl, B extends LoginUrlBuilder<C, B>> {
        private String url;
        private String forwardText;
        private String botUsername;
        private Boolean requestWriteAccess;

        @JsonProperty(value="url")
        public B url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this.self();
        }

        @JsonProperty(value="forward_text")
        public B forwardText(String forwardText) {
            this.forwardText = forwardText;
            return this.self();
        }

        @JsonProperty(value="bot_username")
        public B botUsername(String botUsername) {
            this.botUsername = botUsername;
            return this.self();
        }

        @JsonProperty(value="request_write_access")
        public B requestWriteAccess(Boolean requestWriteAccess) {
            this.requestWriteAccess = requestWriteAccess;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "LoginUrl.LoginUrlBuilder(url=" + this.url + ", forwardText=" + this.forwardText + ", botUsername=" + this.botUsername + ", requestWriteAccess=" + this.requestWriteAccess + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class LoginUrlBuilderImpl
    extends LoginUrlBuilder<LoginUrl, LoginUrlBuilderImpl> {
        private LoginUrlBuilderImpl() {
        }

        @Override
        protected LoginUrlBuilderImpl self() {
            return this;
        }

        @Override
        public LoginUrl build() {
            return new LoginUrl(this);
        }
    }
}

