/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.User;

@JsonDeserialize(builder=MessageEntityBuilderImpl.class)
public class MessageEntity
implements BotApiObject {
    private static final String TYPE_FIELD = "type";
    private static final String OFFSET_FIELD = "offset";
    private static final String LENGTH_FIELD = "length";
    private static final String URL_FIELD = "url";
    private static final String USER_FIELD = "user";
    private static final String LANGUAGE_FIELD = "language";
    private static final String CUSTOMEMOJI_FIELD = "custom_emoji_id";
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="offset")
    @NonNull
    private Integer offset;
    @JsonProperty(value="length")
    @NonNull
    private Integer length;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="user")
    private User user;
    @JsonProperty(value="language")
    private String language;
    @JsonProperty(value="custom_emoji_id")
    private String customEmojiId;
    @JsonIgnore
    private String text;

    public void computeText(String message) {
        if (message != null) {
            this.text = message.substring(this.offset, this.offset + this.length);
        }
    }

    protected MessageEntity(MessageEntityBuilder<?, ?> b) {
        this.type = b.type;
        if (this.type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.offset = b.offset;
        if (this.offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.length = b.length;
        if (this.length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.url = b.url;
        this.user = b.user;
        this.language = b.language;
        this.customEmojiId = b.customEmojiId;
        this.text = b.text;
    }

    public static MessageEntityBuilder<?, ?> builder() {
        return new MessageEntityBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEntity)) {
            return false;
        }
        MessageEntity other = (MessageEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$customEmojiId = this.getCustomEmojiId();
        String other$customEmojiId = other.getCustomEmojiId();
        if (this$customEmojiId == null ? other$customEmojiId != null : !this$customEmojiId.equals(other$customEmojiId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $customEmojiId = this.getCustomEmojiId();
        result = result * 59 + ($customEmojiId == null ? 43 : $customEmojiId.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public Integer getOffset() {
        return this.offset;
    }

    @NonNull
    public Integer getLength() {
        return this.length;
    }

    public String getUrl() {
        return this.url;
    }

    public User getUser() {
        return this.user;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCustomEmojiId() {
        return this.customEmojiId;
    }

    public String getText() {
        return this.text;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="offset")
    public void setOffset(@NonNull Integer offset) {
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.offset = offset;
    }

    @JsonProperty(value="length")
    public void setLength(@NonNull Integer length) {
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.length = length;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="user")
    public void setUser(User user) {
        this.user = user;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="custom_emoji_id")
    public void setCustomEmojiId(String customEmojiId) {
        this.customEmojiId = customEmojiId;
    }

    @JsonIgnore
    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "MessageEntity(type=" + this.getType() + ", offset=" + this.getOffset() + ", length=" + this.getLength() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", language=" + this.getLanguage() + ", customEmojiId=" + this.getCustomEmojiId() + ", text=" + this.getText() + ")";
    }

    public MessageEntity(@NonNull String type, @NonNull Integer offset, @NonNull Integer length) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.type = type;
        this.offset = offset;
        this.length = length;
    }

    public MessageEntity(@NonNull String type, @NonNull Integer offset, @NonNull Integer length, String url, User user, String language, String customEmojiId, String text) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.type = type;
        this.offset = offset;
        this.length = length;
        this.url = url;
        this.user = user;
        this.language = language;
        this.customEmojiId = customEmojiId;
        this.text = text;
    }

    public static abstract class MessageEntityBuilder<C extends MessageEntity, B extends MessageEntityBuilder<C, B>> {
        private String type;
        private Integer offset;
        private Integer length;
        private String url;
        private User user;
        private String language;
        private String customEmojiId;
        private String text;

        @JsonProperty(value="type")
        public B type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this.self();
        }

        @JsonProperty(value="offset")
        public B offset(@NonNull Integer offset) {
            if (offset == null) {
                throw new NullPointerException("offset is marked non-null but is null");
            }
            this.offset = offset;
            return this.self();
        }

        @JsonProperty(value="length")
        public B length(@NonNull Integer length) {
            if (length == null) {
                throw new NullPointerException("length is marked non-null but is null");
            }
            this.length = length;
            return this.self();
        }

        @JsonProperty(value="url")
        public B url(String url) {
            this.url = url;
            return this.self();
        }

        @JsonProperty(value="user")
        public B user(User user) {
            this.user = user;
            return this.self();
        }

        @JsonProperty(value="language")
        public B language(String language) {
            this.language = language;
            return this.self();
        }

        @JsonProperty(value="custom_emoji_id")
        public B customEmojiId(String customEmojiId) {
            this.customEmojiId = customEmojiId;
            return this.self();
        }

        @JsonIgnore
        public B text(String text) {
            this.text = text;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "MessageEntity.MessageEntityBuilder(type=" + this.type + ", offset=" + this.offset + ", length=" + this.length + ", url=" + this.url + ", user=" + this.user + ", language=" + this.language + ", customEmojiId=" + this.customEmojiId + ", text=" + this.text + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class MessageEntityBuilderImpl
    extends MessageEntityBuilder<MessageEntity, MessageEntityBuilderImpl> {
        private MessageEntityBuilderImpl() {
        }

        @Override
        protected MessageEntityBuilderImpl self() {
            return this;
        }

        @Override
        public MessageEntity build() {
            return new MessageEntity(this);
        }
    }
}

