/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=BotCommandBuilderImpl.class)
public class BotCommand
implements BotApiObject,
Validable {
    private static final String COMMAND_FIELD = "command";
    private static final String DESCRIPTION_FIELD = "description";
    @JsonProperty(value="command")
    @NonNull
    private String command;
    @JsonProperty(value="description")
    @NonNull
    private String description;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.command.isEmpty()) {
            throw new TelegramApiValidationException("Command parameter can't be empty", this);
        }
        if (this.description.isEmpty()) {
            throw new TelegramApiValidationException("Description parameter can't be empty", this);
        }
    }

    protected BotCommand(BotCommandBuilder<?, ?> b) {
        this.command = b.command;
        if (this.command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.description = b.description;
        if (this.description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
    }

    public static BotCommandBuilder<?, ?> builder() {
        return new BotCommandBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotCommand)) {
            return false;
        }
        BotCommand other = (BotCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BotCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @NonNull
    public String getCommand() {
        return this.command;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="command")
    public void setCommand(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.command = command;
    }

    @JsonProperty(value="description")
    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    public String toString() {
        return "BotCommand(command=" + this.getCommand() + ", description=" + this.getDescription() + ")";
    }

    public BotCommand(@NonNull String command, @NonNull String description) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.command = command;
        this.description = description;
    }

    public static abstract class BotCommandBuilder<C extends BotCommand, B extends BotCommandBuilder<C, B>> {
        private String command;
        private String description;

        @JsonProperty(value="command")
        public B command(@NonNull String command) {
            if (command == null) {
                throw new NullPointerException("command is marked non-null but is null");
            }
            this.command = command;
            return this.self();
        }

        @JsonProperty(value="description")
        public B description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "BotCommand.BotCommandBuilder(command=" + this.command + ", description=" + this.description + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class BotCommandBuilderImpl
    extends BotCommandBuilder<BotCommand, BotCommandBuilderImpl> {
        private BotCommandBuilderImpl() {
        }

        @Override
        protected BotCommandBuilderImpl self() {
            return this;
        }

        @Override
        public BotCommand build() {
            return new BotCommand(this);
        }
    }
}

