/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.commands.scope;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScope;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=BotCommandScopeChatMemberBuilderImpl.class)
public class BotCommandScopeChatMember
implements BotCommandScope {
    private static final String TYPE_FIELD = "type";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USERID_FIELD = "user_id";
    @JsonProperty(value="type")
    private final String type = "chat_member";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.userId == 0L) {
            throw new TelegramApiValidationException("UserId parameter can't be empty", this);
        }
    }

    protected BotCommandScopeChatMember(BotCommandScopeChatMemberBuilder<?, ?> b) {
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
    }

    public static BotCommandScopeChatMemberBuilder<?, ?> builder() {
        return new BotCommandScopeChatMemberBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotCommandScopeChatMember)) {
            return false;
        }
        BotCommandScopeChatMember other = (BotCommandScopeChatMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BotCommandScopeChatMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public String toString() {
        return "BotCommandScopeChatMember(type=" + this.getType() + ", chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ")";
    }

    public BotCommandScopeChatMember(@NonNull String chatId, @NonNull Long userId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
    }

    public static abstract class BotCommandScopeChatMemberBuilder<C extends BotCommandScopeChatMember, B extends BotCommandScopeChatMemberBuilder<C, B>> {
        private String chatId;
        private Long userId;

        public BotCommandScopeChatMemberBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this.self();
        }

        @JsonProperty(value="user_id")
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "BotCommandScopeChatMember.BotCommandScopeChatMemberBuilder(chatId=" + this.chatId + ", userId=" + this.userId + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class BotCommandScopeChatMemberBuilderImpl
    extends BotCommandScopeChatMemberBuilder<BotCommandScopeChatMember, BotCommandScopeChatMemberBuilderImpl> {
        private BotCommandScopeChatMemberBuilderImpl() {
        }

        @Override
        protected BotCommandScopeChatMemberBuilderImpl self() {
            return this;
        }

        @Override
        public BotCommandScopeChatMember build() {
            return new BotCommandScopeChatMember(this);
        }
    }
}

