/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=InlineQueryResultGifBuilderImpl.class)
public class InlineQueryResultGif
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String GIFURL_FIELD = "gif_url";
    private static final String GIFWIDTH_FIELD = "gif_width";
    private static final String GIFHEIGHT_FIELD = "gif_height";
    private static final String THUMBNAIL_URL_FIELD = "thumbnail_url";
    private static final String THUMBNAIL_MIMETYPE_FIELD = "thumbnail_mime_type";
    private static final String TITLE_FIELD = "title";
    private static final String CAPTION_FIELD = "caption";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String GIF_DURATION_FIELD = "gif_duration";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "gif";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="gif_url")
    @NonNull
    private String gifUrl;
    @JsonProperty(value="gif_width")
    private Integer gifWidth;
    @JsonProperty(value="gif_height")
    private Integer gifHeight;
    @JsonProperty(value="thumbnail_url")
    private String thumbnailUrl;
    @JsonProperty(value="thumbnail_mime_type")
    private String thumbnailMimeType;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="gif_duration")
    private Integer gifDuration;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.gifUrl.isEmpty()) {
            throw new TelegramApiValidationException("GifUrl parameter can't be empty", this);
        }
        if (this.thumbnailMimeType != null && !VALIDTHUMBTYPES.contains(this.thumbnailMimeType)) {
            throw new TelegramApiValidationException("ThumbUrlType parameter must be one of \u201cimage/jpeg\u201d, \u201cimage/gif\u201d, or \u201cvideo/mp4\u201d", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    protected InlineQueryResultGif(InlineQueryResultGifBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.gifUrl = b.gifUrl;
        if (this.gifUrl == null) {
            throw new NullPointerException("gifUrl is marked non-null but is null");
        }
        this.gifWidth = b.gifWidth;
        this.gifHeight = b.gifHeight;
        this.thumbnailUrl = b.thumbnailUrl;
        this.thumbnailMimeType = b.thumbnailMimeType;
        this.title = b.title;
        this.caption = b.caption;
        this.inputMessageContent = b.inputMessageContent;
        this.replyMarkup = b.replyMarkup;
        this.gifDuration = b.gifDuration;
        this.parseMode = b.parseMode;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
    }

    public static InlineQueryResultGifBuilder<?, ?> builder() {
        return new InlineQueryResultGifBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultGif)) {
            return false;
        }
        InlineQueryResultGif other = (InlineQueryResultGif)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$gifWidth = this.getGifWidth();
        Integer other$gifWidth = other.getGifWidth();
        if (this$gifWidth == null ? other$gifWidth != null : !((Object)this$gifWidth).equals(other$gifWidth)) {
            return false;
        }
        Integer this$gifHeight = this.getGifHeight();
        Integer other$gifHeight = other.getGifHeight();
        if (this$gifHeight == null ? other$gifHeight != null : !((Object)this$gifHeight).equals(other$gifHeight)) {
            return false;
        }
        Integer this$gifDuration = this.getGifDuration();
        Integer other$gifDuration = other.getGifDuration();
        if (this$gifDuration == null ? other$gifDuration != null : !((Object)this$gifDuration).equals(other$gifDuration)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$gifUrl = this.getGifUrl();
        String other$gifUrl = other.getGifUrl();
        if (this$gifUrl == null ? other$gifUrl != null : !this$gifUrl.equals(other$gifUrl)) {
            return false;
        }
        String this$thumbnailUrl = this.getThumbnailUrl();
        String other$thumbnailUrl = other.getThumbnailUrl();
        if (this$thumbnailUrl == null ? other$thumbnailUrl != null : !this$thumbnailUrl.equals(other$thumbnailUrl)) {
            return false;
        }
        String this$thumbnailMimeType = this.getThumbnailMimeType();
        String other$thumbnailMimeType = other.getThumbnailMimeType();
        if (this$thumbnailMimeType == null ? other$thumbnailMimeType != null : !this$thumbnailMimeType.equals(other$thumbnailMimeType)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultGif;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $gifWidth = this.getGifWidth();
        result = result * 59 + ($gifWidth == null ? 43 : ((Object)$gifWidth).hashCode());
        Integer $gifHeight = this.getGifHeight();
        result = result * 59 + ($gifHeight == null ? 43 : ((Object)$gifHeight).hashCode());
        Integer $gifDuration = this.getGifDuration();
        result = result * 59 + ($gifDuration == null ? 43 : ((Object)$gifDuration).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $gifUrl = this.getGifUrl();
        result = result * 59 + ($gifUrl == null ? 43 : $gifUrl.hashCode());
        String $thumbnailUrl = this.getThumbnailUrl();
        result = result * 59 + ($thumbnailUrl == null ? 43 : $thumbnailUrl.hashCode());
        String $thumbnailMimeType = this.getThumbnailMimeType();
        result = result * 59 + ($thumbnailMimeType == null ? 43 : $thumbnailMimeType.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getGifUrl() {
        return this.gifUrl;
    }

    public Integer getGifWidth() {
        return this.gifWidth;
    }

    public Integer getGifHeight() {
        return this.gifHeight;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getThumbnailMimeType() {
        return this.thumbnailMimeType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public Integer getGifDuration() {
        return this.gifDuration;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="gif_url")
    public void setGifUrl(@NonNull String gifUrl) {
        if (gifUrl == null) {
            throw new NullPointerException("gifUrl is marked non-null but is null");
        }
        this.gifUrl = gifUrl;
    }

    @JsonProperty(value="gif_width")
    public void setGifWidth(Integer gifWidth) {
        this.gifWidth = gifWidth;
    }

    @JsonProperty(value="gif_height")
    public void setGifHeight(Integer gifHeight) {
        this.gifHeight = gifHeight;
    }

    @JsonProperty(value="thumbnail_url")
    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @JsonProperty(value="thumbnail_mime_type")
    public void setThumbnailMimeType(String thumbnailMimeType) {
        this.thumbnailMimeType = thumbnailMimeType;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="gif_duration")
    public void setGifDuration(Integer gifDuration) {
        this.gifDuration = gifDuration;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultGif(type=" + this.getType() + ", id=" + this.getId() + ", gifUrl=" + this.getGifUrl() + ", gifWidth=" + this.getGifWidth() + ", gifHeight=" + this.getGifHeight() + ", thumbnailUrl=" + this.getThumbnailUrl() + ", thumbnailMimeType=" + this.getThumbnailMimeType() + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", gifDuration=" + this.getGifDuration() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultGif(@NonNull String id, @NonNull String gifUrl) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (gifUrl == null) {
            throw new NullPointerException("gifUrl is marked non-null but is null");
        }
        this.id = id;
        this.gifUrl = gifUrl;
    }

    public InlineQueryResultGif(@NonNull String id, @NonNull String gifUrl, Integer gifWidth, Integer gifHeight, String thumbnailUrl, String thumbnailMimeType, String title, String caption, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, Integer gifDuration, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (gifUrl == null) {
            throw new NullPointerException("gifUrl is marked non-null but is null");
        }
        this.id = id;
        this.gifUrl = gifUrl;
        this.gifWidth = gifWidth;
        this.gifHeight = gifHeight;
        this.thumbnailUrl = thumbnailUrl;
        this.thumbnailMimeType = thumbnailMimeType;
        this.title = title;
        this.caption = caption;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.gifDuration = gifDuration;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static abstract class InlineQueryResultGifBuilder<C extends InlineQueryResultGif, B extends InlineQueryResultGifBuilder<C, B>> {
        private String id;
        private String gifUrl;
        private Integer gifWidth;
        private Integer gifHeight;
        private String thumbnailUrl;
        private String thumbnailMimeType;
        private String title;
        private String caption;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private Integer gifDuration;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        @JsonProperty(value="id")
        public B id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="gif_url")
        public B gifUrl(@NonNull String gifUrl) {
            if (gifUrl == null) {
                throw new NullPointerException("gifUrl is marked non-null but is null");
            }
            this.gifUrl = gifUrl;
            return this.self();
        }

        @JsonProperty(value="gif_width")
        public B gifWidth(Integer gifWidth) {
            this.gifWidth = gifWidth;
            return this.self();
        }

        @JsonProperty(value="gif_height")
        public B gifHeight(Integer gifHeight) {
            this.gifHeight = gifHeight;
            return this.self();
        }

        @JsonProperty(value="thumbnail_url")
        public B thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this.self();
        }

        @JsonProperty(value="thumbnail_mime_type")
        public B thumbnailMimeType(String thumbnailMimeType) {
            this.thumbnailMimeType = thumbnailMimeType;
            return this.self();
        }

        @JsonProperty(value="title")
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="caption")
        public B caption(String caption) {
            this.caption = caption;
            return this.self();
        }

        @JsonProperty(value="input_message_content")
        public B inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this.self();
        }

        @JsonProperty(value="reply_markup")
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this.self();
        }

        @JsonProperty(value="gif_duration")
        public B gifDuration(Integer gifDuration) {
            this.gifDuration = gifDuration;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this.self();
        }

        @JsonProperty(value="caption_entities")
        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this.self();
        }

        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InlineQueryResultGif.InlineQueryResultGifBuilder(id=" + this.id + ", gifUrl=" + this.gifUrl + ", gifWidth=" + this.gifWidth + ", gifHeight=" + this.gifHeight + ", thumbnailUrl=" + this.thumbnailUrl + ", thumbnailMimeType=" + this.thumbnailMimeType + ", title=" + this.title + ", caption=" + this.caption + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", gifDuration=" + this.gifDuration + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InlineQueryResultGifBuilderImpl
    extends InlineQueryResultGifBuilder<InlineQueryResultGif, InlineQueryResultGifBuilderImpl> {
        private InlineQueryResultGifBuilderImpl() {
        }

        @Override
        protected InlineQueryResultGifBuilderImpl self() {
            return this;
        }

        @Override
        public InlineQueryResultGif build() {
            return new InlineQueryResultGif(this);
        }
    }
}

