/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=InlineQueryResultCachedGifBuilderImpl.class)
public class InlineQueryResultCachedGif
implements InlineQueryResult {
    private static final List<String> VALIDTHUMBTYPES = Collections.unmodifiableList(Arrays.asList("image/jpeg", "image/gif", "video/mp4"));
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String GIF_FILE_ID_FIELD = "gif_file_id";
    private static final String TITLE_FIELD = "title";
    private static final String CAPTION_FIELD = "caption";
    private static final String THUMBURL_FIELD = "thumb_url";
    private static final String THUMBMIMETYPE_FIELD = "thumb_mime_type";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "gif";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="gif_file_id")
    @NonNull
    private String gifFileId;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    @JsonProperty(value="thumb_mime_type")
    private String thumbUrlType;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.gifFileId == null || this.gifFileId.isEmpty()) {
            throw new TelegramApiValidationException("GifFileId parameter can't be empty", this);
        }
        if (this.thumbUrlType != null && !VALIDTHUMBTYPES.contains(this.thumbUrlType)) {
            throw new TelegramApiValidationException("ThumbUrlType parameter must be one of \u201cimage/jpeg\u201d, \u201cimage/gif\u201d, or \u201cvideo/mp4\u201d", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    protected InlineQueryResultCachedGif(InlineQueryResultCachedGifBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.gifFileId = b.gifFileId;
        if (this.gifFileId == null) {
            throw new NullPointerException("gifFileId is marked non-null but is null");
        }
        this.title = b.title;
        this.caption = b.caption;
        this.inputMessageContent = b.inputMessageContent;
        this.replyMarkup = b.replyMarkup;
        this.parseMode = b.parseMode;
        this.thumbUrl = b.thumbUrl;
        this.thumbUrlType = b.thumbUrlType;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
    }

    public static InlineQueryResultCachedGifBuilder<?, ?> builder() {
        return new InlineQueryResultCachedGifBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultCachedGif)) {
            return false;
        }
        InlineQueryResultCachedGif other = (InlineQueryResultCachedGif)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$gifFileId = this.getGifFileId();
        String other$gifFileId = other.getGifFileId();
        if (this$gifFileId == null ? other$gifFileId != null : !this$gifFileId.equals(other$gifFileId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        String this$thumbUrl = this.getThumbUrl();
        String other$thumbUrl = other.getThumbUrl();
        if (this$thumbUrl == null ? other$thumbUrl != null : !this$thumbUrl.equals(other$thumbUrl)) {
            return false;
        }
        String this$thumbUrlType = this.getThumbUrlType();
        String other$thumbUrlType = other.getThumbUrlType();
        if (this$thumbUrlType == null ? other$thumbUrlType != null : !this$thumbUrlType.equals(other$thumbUrlType)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultCachedGif;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $gifFileId = this.getGifFileId();
        result = result * 59 + ($gifFileId == null ? 43 : $gifFileId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        String $thumbUrl = this.getThumbUrl();
        result = result * 59 + ($thumbUrl == null ? 43 : $thumbUrl.hashCode());
        String $thumbUrlType = this.getThumbUrlType();
        result = result * 59 + ($thumbUrlType == null ? 43 : $thumbUrlType.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getGifFileId() {
        return this.gifFileId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public String getThumbUrlType() {
        return this.thumbUrlType;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="gif_file_id")
    public void setGifFileId(@NonNull String gifFileId) {
        if (gifFileId == null) {
            throw new NullPointerException("gifFileId is marked non-null but is null");
        }
        this.gifFileId = gifFileId;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="thumb_url")
    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    @JsonProperty(value="thumb_mime_type")
    public void setThumbUrlType(String thumbUrlType) {
        this.thumbUrlType = thumbUrlType;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultCachedGif(type=" + this.getType() + ", id=" + this.getId() + ", gifFileId=" + this.getGifFileId() + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", thumbUrl=" + this.getThumbUrl() + ", thumbUrlType=" + this.getThumbUrlType() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultCachedGif(@NonNull String id, @NonNull String gifFileId) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (gifFileId == null) {
            throw new NullPointerException("gifFileId is marked non-null but is null");
        }
        this.id = id;
        this.gifFileId = gifFileId;
    }

    public InlineQueryResultCachedGif(@NonNull String id, @NonNull String gifFileId, String title, String caption, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, String parseMode, String thumbUrl, String thumbUrlType, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (gifFileId == null) {
            throw new NullPointerException("gifFileId is marked non-null but is null");
        }
        this.id = id;
        this.gifFileId = gifFileId;
        this.title = title;
        this.caption = caption;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.thumbUrl = thumbUrl;
        this.thumbUrlType = thumbUrlType;
        this.captionEntities = captionEntities;
    }

    public static abstract class InlineQueryResultCachedGifBuilder<C extends InlineQueryResultCachedGif, B extends InlineQueryResultCachedGifBuilder<C, B>> {
        private String id;
        private String gifFileId;
        private String title;
        private String caption;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private String parseMode;
        private String thumbUrl;
        private String thumbUrlType;
        private ArrayList<MessageEntity> captionEntities;

        @JsonProperty(value="id")
        public B id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="gif_file_id")
        public B gifFileId(@NonNull String gifFileId) {
            if (gifFileId == null) {
                throw new NullPointerException("gifFileId is marked non-null but is null");
            }
            this.gifFileId = gifFileId;
            return this.self();
        }

        @JsonProperty(value="title")
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="caption")
        public B caption(String caption) {
            this.caption = caption;
            return this.self();
        }

        @JsonProperty(value="input_message_content")
        public B inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this.self();
        }

        @JsonProperty(value="reply_markup")
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        @JsonProperty(value="thumb_url")
        public B thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this.self();
        }

        @JsonProperty(value="thumb_mime_type")
        public B thumbUrlType(String thumbUrlType) {
            this.thumbUrlType = thumbUrlType;
            return this.self();
        }

        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this.self();
        }

        @JsonProperty(value="caption_entities")
        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this.self();
        }

        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InlineQueryResultCachedGif.InlineQueryResultCachedGifBuilder(id=" + this.id + ", gifFileId=" + this.gifFileId + ", title=" + this.title + ", caption=" + this.caption + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", thumbUrl=" + this.thumbUrl + ", thumbUrlType=" + this.thumbUrlType + ", captionEntities=" + this.captionEntities + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InlineQueryResultCachedGifBuilderImpl
    extends InlineQueryResultCachedGifBuilder<InlineQueryResultCachedGif, InlineQueryResultCachedGifBuilderImpl> {
        private InlineQueryResultCachedGifBuilderImpl() {
        }

        @Override
        protected InlineQueryResultCachedGifBuilderImpl self() {
            return this;
        }

        @Override
        public InlineQueryResultCachedGif build() {
            return new InlineQueryResultCachedGif(this);
        }
    }
}

