/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=InputMediaAudioBuilderImpl.class)
public class InputMediaAudio
extends InputMedia {
    private static final String TYPE = "audio";
    public static final String DURATION_FIELD = "duration";
    public static final String PERFORMER_FIELD = "performer";
    public static final String TITLE_FIELD = "title";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="performer")
    private String performer;
    @JsonProperty(value="title")
    private String title;
    private InputFile thumbnail;

    public InputMediaAudio(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaAudio(File mediaFile, String fileName) {
        this.setMedia(mediaFile, fileName);
    }

    public InputMediaAudio(InputStream mediaStream, String fileName) {
        this.setMedia(mediaStream, fileName);
    }

    public InputMediaAudio(@NonNull String media, String caption, String parseMode, List<MessageEntity> captionEntities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, Integer duration, String performer, String title, InputFile thumbnail) {
        super(media, caption, parseMode, captionEntities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.duration = duration;
        this.performer = performer;
        this.title = title;
        this.thumbnail = thumbnail;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    protected InputMediaAudio(InputMediaAudioBuilder<?, ?> b) {
        super(b);
        this.duration = b.duration;
        this.performer = b.performer;
        this.title = b.title;
        this.thumbnail = b.thumbnail;
    }

    public static InputMediaAudioBuilder<?, ?> builder() {
        return new InputMediaAudioBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaAudio)) {
            return false;
        }
        InputMediaAudio other = (InputMediaAudio)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$performer = this.getPerformer();
        String other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaAudio;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getTitle() {
        return this.title;
    }

    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    @JsonProperty(value="duration")
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @JsonProperty(value="performer")
    public void setPerformer(String performer) {
        this.performer = performer;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Override
    public String toString() {
        return "InputMediaAudio(duration=" + this.getDuration() + ", performer=" + this.getPerformer() + ", title=" + this.getTitle() + ", thumbnail=" + this.getThumbnail() + ")";
    }

    public static abstract class InputMediaAudioBuilder<C extends InputMediaAudio, B extends InputMediaAudioBuilder<C, B>>
    extends InputMedia.InputMediaBuilder<C, B> {
        private Integer duration;
        private String performer;
        private String title;
        private InputFile thumbnail;

        @JsonProperty(value="duration")
        public B duration(Integer duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @JsonProperty(value="performer")
        public B performer(String performer) {
            this.performer = performer;
            return (B)this.self();
        }

        @JsonProperty(value="title")
        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        public B thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InputMediaAudio.InputMediaAudioBuilder(super=" + super.toString() + ", duration=" + this.duration + ", performer=" + this.performer + ", title=" + this.title + ", thumbnail=" + this.thumbnail + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InputMediaAudioBuilderImpl
    extends InputMediaAudioBuilder<InputMediaAudio, InputMediaAudioBuilderImpl> {
        private InputMediaAudioBuilderImpl() {
        }

        @Override
        protected InputMediaAudioBuilderImpl self() {
            return this;
        }

        @Override
        public InputMediaAudio build() {
            return new InputMediaAudio(this);
        }
    }
}

