/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=InputMediaPhotoBuilderImpl.class)
public class InputMediaPhoto
extends InputMedia {
    private static final String TYPE = "photo";
    public static final String HASSPOILER_FIELD = "has_spoiler";
    @JsonProperty(value="has_spoiler")
    private Boolean hasSpoiler;

    public InputMediaPhoto(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaPhoto(File mediaFile, String fileName) {
        this.setMedia(mediaFile, fileName);
    }

    public InputMediaPhoto(InputStream mediaStream, String fileName) {
        this.setMedia(mediaStream, fileName);
    }

    public InputMediaPhoto(@NonNull String media, String caption, String parseMode, List<MessageEntity> captionEntities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, Boolean hasSpoiler) {
        super(media, caption, parseMode, captionEntities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.hasSpoiler = hasSpoiler;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    protected InputMediaPhoto(InputMediaPhotoBuilder<?, ?> b) {
        super(b);
        this.hasSpoiler = b.hasSpoiler;
    }

    public static InputMediaPhotoBuilder<?, ?> builder() {
        return new InputMediaPhotoBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaPhoto)) {
            return false;
        }
        InputMediaPhoto other = (InputMediaPhoto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$hasSpoiler = this.getHasSpoiler();
        Boolean other$hasSpoiler = other.getHasSpoiler();
        return !(this$hasSpoiler == null ? other$hasSpoiler != null : !((Object)this$hasSpoiler).equals(other$hasSpoiler));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaPhoto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $hasSpoiler = this.getHasSpoiler();
        result = result * 59 + ($hasSpoiler == null ? 43 : ((Object)$hasSpoiler).hashCode());
        return result;
    }

    public Boolean getHasSpoiler() {
        return this.hasSpoiler;
    }

    @JsonProperty(value="has_spoiler")
    public void setHasSpoiler(Boolean hasSpoiler) {
        this.hasSpoiler = hasSpoiler;
    }

    @Override
    public String toString() {
        return "InputMediaPhoto(hasSpoiler=" + this.getHasSpoiler() + ")";
    }

    public static abstract class InputMediaPhotoBuilder<C extends InputMediaPhoto, B extends InputMediaPhotoBuilder<C, B>>
    extends InputMedia.InputMediaBuilder<C, B> {
        private Boolean hasSpoiler;

        @JsonProperty(value="has_spoiler")
        public B hasSpoiler(Boolean hasSpoiler) {
            this.hasSpoiler = hasSpoiler;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InputMediaPhoto.InputMediaPhotoBuilder(super=" + super.toString() + ", hasSpoiler=" + this.hasSpoiler + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InputMediaPhotoBuilderImpl
    extends InputMediaPhotoBuilder<InputMediaPhoto, InputMediaPhotoBuilderImpl> {
        private InputMediaPhotoBuilderImpl() {
        }

        @Override
        protected InputMediaPhotoBuilderImpl self() {
            return this;
        }

        @Override
        public InputMediaPhoto build() {
            return new InputMediaPhoto(this);
        }
    }
}

