/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize(builder=KeyboardButtonRequestUsersBuilderImpl.class)
public class KeyboardButtonRequestUsers
implements Validable,
BotApiObject {
    private static final String REQUEST_ID_FIELD = "request_id";
    private static final String USER_IS_BOT_FIELD = "user_is_bot";
    private static final String USER_IS_PREMIUM_FIELD = "user_is_premium";
    private static final String MAX_QUANTITY_FIELD = "max_quantity";
    @JsonProperty(value="request_id")
    @NonNull
    private String requestId;
    @JsonProperty(value="user_is_bot")
    private Boolean userIsBot;
    @JsonProperty(value="user_is_premium")
    private Boolean userIsPremium;
    @JsonProperty(value="max_quantity")
    private Integer maxQuantity;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.requestId.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.maxQuantity != null && (this.maxQuantity < 1 || this.maxQuantity > 10)) {
            throw new TelegramApiValidationException("MaxQuantity parameter must be between 1 and 10", this);
        }
    }

    protected KeyboardButtonRequestUsers(KeyboardButtonRequestUsersBuilder<?, ?> b) {
        this.requestId = b.requestId;
        if (this.requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.userIsBot = b.userIsBot;
        this.userIsPremium = b.userIsPremium;
        this.maxQuantity = b.maxQuantity;
    }

    public static KeyboardButtonRequestUsersBuilder<?, ?> builder() {
        return new KeyboardButtonRequestUsersBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyboardButtonRequestUsers)) {
            return false;
        }
        KeyboardButtonRequestUsers other = (KeyboardButtonRequestUsers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$userIsBot = this.getUserIsBot();
        Boolean other$userIsBot = other.getUserIsBot();
        if (this$userIsBot == null ? other$userIsBot != null : !((Object)this$userIsBot).equals(other$userIsBot)) {
            return false;
        }
        Boolean this$userIsPremium = this.getUserIsPremium();
        Boolean other$userIsPremium = other.getUserIsPremium();
        if (this$userIsPremium == null ? other$userIsPremium != null : !((Object)this$userIsPremium).equals(other$userIsPremium)) {
            return false;
        }
        Integer this$maxQuantity = this.getMaxQuantity();
        Integer other$maxQuantity = other.getMaxQuantity();
        if (this$maxQuantity == null ? other$maxQuantity != null : !((Object)this$maxQuantity).equals(other$maxQuantity)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyboardButtonRequestUsers;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $userIsBot = this.getUserIsBot();
        result = result * 59 + ($userIsBot == null ? 43 : ((Object)$userIsBot).hashCode());
        Boolean $userIsPremium = this.getUserIsPremium();
        result = result * 59 + ($userIsPremium == null ? 43 : ((Object)$userIsPremium).hashCode());
        Integer $maxQuantity = this.getMaxQuantity();
        result = result * 59 + ($maxQuantity == null ? 43 : ((Object)$maxQuantity).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    @NonNull
    public String getRequestId() {
        return this.requestId;
    }

    public Boolean getUserIsBot() {
        return this.userIsBot;
    }

    public Boolean getUserIsPremium() {
        return this.userIsPremium;
    }

    public Integer getMaxQuantity() {
        return this.maxQuantity;
    }

    @JsonProperty(value="request_id")
    public void setRequestId(@NonNull String requestId) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
    }

    @JsonProperty(value="user_is_bot")
    public void setUserIsBot(Boolean userIsBot) {
        this.userIsBot = userIsBot;
    }

    @JsonProperty(value="user_is_premium")
    public void setUserIsPremium(Boolean userIsPremium) {
        this.userIsPremium = userIsPremium;
    }

    @JsonProperty(value="max_quantity")
    public void setMaxQuantity(Integer maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    public String toString() {
        return "KeyboardButtonRequestUsers(requestId=" + this.getRequestId() + ", userIsBot=" + this.getUserIsBot() + ", userIsPremium=" + this.getUserIsPremium() + ", maxQuantity=" + this.getMaxQuantity() + ")";
    }

    public KeyboardButtonRequestUsers(@NonNull String requestId) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
    }

    public KeyboardButtonRequestUsers(@NonNull String requestId, Boolean userIsBot, Boolean userIsPremium, Integer maxQuantity) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
        this.userIsBot = userIsBot;
        this.userIsPremium = userIsPremium;
        this.maxQuantity = maxQuantity;
    }

    public static abstract class KeyboardButtonRequestUsersBuilder<C extends KeyboardButtonRequestUsers, B extends KeyboardButtonRequestUsersBuilder<C, B>> {
        private String requestId;
        private Boolean userIsBot;
        private Boolean userIsPremium;
        private Integer maxQuantity;

        @JsonProperty(value="request_id")
        public B requestId(@NonNull String requestId) {
            if (requestId == null) {
                throw new NullPointerException("requestId is marked non-null but is null");
            }
            this.requestId = requestId;
            return this.self();
        }

        @JsonProperty(value="user_is_bot")
        public B userIsBot(Boolean userIsBot) {
            this.userIsBot = userIsBot;
            return this.self();
        }

        @JsonProperty(value="user_is_premium")
        public B userIsPremium(Boolean userIsPremium) {
            this.userIsPremium = userIsPremium;
            return this.self();
        }

        @JsonProperty(value="max_quantity")
        public B maxQuantity(Integer maxQuantity) {
            this.maxQuantity = maxQuantity;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "KeyboardButtonRequestUsers.KeyboardButtonRequestUsersBuilder(requestId=" + this.requestId + ", userIsBot=" + this.userIsBot + ", userIsPremium=" + this.userIsPremium + ", maxQuantity=" + this.maxQuantity + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class KeyboardButtonRequestUsersBuilderImpl
    extends KeyboardButtonRequestUsersBuilder<KeyboardButtonRequestUsers, KeyboardButtonRequestUsersBuilderImpl> {
        private KeyboardButtonRequestUsersBuilderImpl() {
        }

        @Override
        protected KeyboardButtonRequestUsersBuilderImpl self() {
            return this;
        }

        @Override
        public KeyboardButtonRequestUsers build() {
            return new KeyboardButtonRequestUsers(this);
        }
    }
}

