/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.boosts;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.boost.UserChatBoosts;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetUserChatBoosts
extends BotApiMethod<UserChatBoosts> {
    public static final String PATH = "getUserChatBoosts";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public UserChatBoosts deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, UserChatBoosts.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty string", this);
        }
        if (this.userId <= 0L) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
    }

    @Generated
    public static GetUserChatBoostsBuilder builder() {
        return new GetUserChatBoostsBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetUserChatBoosts)) {
            return false;
        }
        GetUserChatBoosts other = (GetUserChatBoosts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GetUserChatBoosts;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    public String toString() {
        return "GetUserChatBoosts(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ")";
    }

    @Generated
    public GetUserChatBoosts() {
    }

    @Generated
    public GetUserChatBoosts(@NonNull String chatId, @NonNull Long userId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
    }

    public static class GetUserChatBoostsBuilder {
        @Generated
        private String chatId;
        @Generated
        private Long userId;

        public GetUserChatBoostsBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @Generated
        GetUserChatBoostsBuilder() {
        }

        @JsonProperty(value="chat_id")
        @Generated
        public GetUserChatBoostsBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="user_id")
        @Generated
        public GetUserChatBoostsBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @Generated
        public GetUserChatBoosts build() {
            return new GetUserChatBoosts(this.chatId, this.userId);
        }

        @Generated
        public String toString() {
            return "GetUserChatBoosts.GetUserChatBoostsBuilder(chatId=" + this.chatId + ", userId=" + this.userId + ")";
        }
    }
}

