/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.media.paid.InputPaidMedia;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SendPaidMediaBuilderImpl.class)
public class SendPaidMedia
extends PartialBotApiMethod<ArrayList<Message>> {
    public static final String PATH = "sendPaidMedia";
    public static final String CHAT_ID_FIELD = "chat_id";
    public static final String STAR_COUNT_FIELD = "star_count";
    public static final String MEDIA_FIELD = "media";
    public static final String CAPTION_FIELD = "caption";
    public static final String PARSE_MODE_FIELD = "parse_mode";
    public static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    public static final String SHOW_CAPTION_ABOVE_MEDIA_FIELD = "show_caption_above_media";
    public static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    public static final String PROTECT_CONTENT_FIELD = "protect_content";
    public static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    public static final String REPLY_MARKUP_FIELD = "reply_markup";
    public static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    public static final String PAYLOAD_FIELD = "payload";
    public static final String ALLOW_PAID_BROADCAST_FIELD = "allow_paid_broadcast";
    @NonNull
    private String chatId;
    @NonNull
    private Integer starCount;
    @NonNull
    private List<InputPaidMedia> media;
    private String caption;
    private String parseMode;
    private List<MessageEntity> captionEntities;
    private Boolean showCaptionAboveMedia;
    private Boolean disableNotification;
    private Boolean protectContent;
    private ReplyParameters replyParameters;
    private ReplyKeyboard replyMarkup;
    private String businessConnectionId;
    private String payload;
    private Boolean allowPaidBroadcast;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public ArrayList<Message> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.media.isEmpty()) {
            throw new TelegramApiValidationException("Media parameter can't be empty", this);
        }
        if (this.media.size() < 2 || this.media.size() > 10) {
            throw new TelegramApiValidationException("Number of media should be between 2 and 10", this);
        }
        for (InputPaidMedia inputMedia : this.media) {
            if (inputMedia == null) {
                throw new TelegramApiValidationException("Media parameter can not be empty", this);
            }
            inputMedia.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Generated
    protected SendPaidMedia(SendPaidMediaBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.starCount = b.starCount;
        if (this.starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.media = b.media;
        if (this.media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.caption = b.caption;
        this.parseMode = b.parseMode;
        this.captionEntities = b.captionEntities;
        this.showCaptionAboveMedia = b.showCaptionAboveMedia;
        this.disableNotification = b.disableNotification;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
        this.replyMarkup = b.replyMarkup;
        this.businessConnectionId = b.businessConnectionId;
        this.payload = b.payload;
        this.allowPaidBroadcast = b.allowPaidBroadcast;
    }

    @Generated
    public static SendPaidMediaBuilder<?, ?> builder() {
        return new SendPaidMediaBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendPaidMedia)) {
            return false;
        }
        SendPaidMedia other = (SendPaidMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$starCount = this.getStarCount();
        Integer other$starCount = other.getStarCount();
        if (this$starCount == null ? other$starCount != null : !((Object)this$starCount).equals(other$starCount)) {
            return false;
        }
        Boolean this$showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        Boolean other$showCaptionAboveMedia = other.getShowCaptionAboveMedia();
        if (this$showCaptionAboveMedia == null ? other$showCaptionAboveMedia != null : !((Object)this$showCaptionAboveMedia).equals(other$showCaptionAboveMedia)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        Boolean this$allowPaidBroadcast = this.getAllowPaidBroadcast();
        Boolean other$allowPaidBroadcast = other.getAllowPaidBroadcast();
        if (this$allowPaidBroadcast == null ? other$allowPaidBroadcast != null : !((Object)this$allowPaidBroadcast).equals(other$allowPaidBroadcast)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        List<InputPaidMedia> this$media = this.getMedia();
        List<InputPaidMedia> other$media = other.getMedia();
        if (this$media == null ? other$media != null : !((Object)this$media).equals(other$media)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendPaidMedia;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $starCount = this.getStarCount();
        result = result * 59 + ($starCount == null ? 43 : ((Object)$starCount).hashCode());
        Boolean $showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        result = result * 59 + ($showCaptionAboveMedia == null ? 43 : ((Object)$showCaptionAboveMedia).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        Boolean $allowPaidBroadcast = this.getAllowPaidBroadcast();
        result = result * 59 + ($allowPaidBroadcast == null ? 43 : ((Object)$allowPaidBroadcast).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        List<InputPaidMedia> $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : ((Object)$media).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Integer getStarCount() {
        return this.starCount;
    }

    @NonNull
    @Generated
    public List<InputPaidMedia> getMedia() {
        return this.media;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Generated
    public Boolean getShowCaptionAboveMedia() {
        return this.showCaptionAboveMedia;
    }

    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Generated
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @Generated
    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public Boolean getAllowPaidBroadcast() {
        return this.allowPaidBroadcast;
    }

    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @Generated
    public void setStarCount(@NonNull Integer starCount) {
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.starCount = starCount;
    }

    @Generated
    public void setMedia(@NonNull List<InputPaidMedia> media) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
    }

    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @Generated
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @Generated
    public void setShowCaptionAboveMedia(Boolean showCaptionAboveMedia) {
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @Generated
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @Generated
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @Generated
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Generated
    public void setAllowPaidBroadcast(Boolean allowPaidBroadcast) {
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    @Generated
    public String toString() {
        return "SendPaidMedia(chatId=" + this.getChatId() + ", starCount=" + this.getStarCount() + ", media=" + this.getMedia() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ", showCaptionAboveMedia=" + this.getShowCaptionAboveMedia() + ", disableNotification=" + this.getDisableNotification() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ", replyMarkup=" + this.getReplyMarkup() + ", businessConnectionId=" + this.getBusinessConnectionId() + ", payload=" + this.getPayload() + ", allowPaidBroadcast=" + this.getAllowPaidBroadcast() + ")";
    }

    @Generated
    public SendPaidMedia(@NonNull String chatId, @NonNull Integer starCount, @NonNull List<InputPaidMedia> media) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.chatId = chatId;
        this.starCount = starCount;
        this.media = media;
    }

    @Generated
    public SendPaidMedia(@NonNull String chatId, @NonNull Integer starCount, @NonNull List<InputPaidMedia> media, String caption, String parseMode, List<MessageEntity> captionEntities, Boolean showCaptionAboveMedia, Boolean disableNotification, Boolean protectContent, ReplyParameters replyParameters, ReplyKeyboard replyMarkup, String businessConnectionId, String payload, Boolean allowPaidBroadcast) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.chatId = chatId;
        this.starCount = starCount;
        this.media = media;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
        this.showCaptionAboveMedia = showCaptionAboveMedia;
        this.disableNotification = disableNotification;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
        this.replyMarkup = replyMarkup;
        this.businessConnectionId = businessConnectionId;
        this.payload = payload;
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    public static abstract class SendPaidMediaBuilder<C extends SendPaidMedia, B extends SendPaidMediaBuilder<C, B>>
    extends PartialBotApiMethod.PartialBotApiMethodBuilder<ArrayList<Message>, C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer starCount;
        @Generated
        private List<InputPaidMedia> media;
        @Generated
        private String caption;
        @Generated
        private String parseMode;
        @Generated
        private List<MessageEntity> captionEntities;
        @Generated
        private Boolean showCaptionAboveMedia;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Boolean protectContent;
        @Generated
        private ReplyParameters replyParameters;
        @Generated
        private ReplyKeyboard replyMarkup;
        @Generated
        private String businessConnectionId;
        @Generated
        private String payload;
        @Generated
        private Boolean allowPaidBroadcast;

        public SendPaidMediaBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @Generated
        public B starCount(@NonNull Integer starCount) {
            if (starCount == null) {
                throw new NullPointerException("starCount is marked non-null but is null");
            }
            this.starCount = starCount;
            return (B)this.self();
        }

        @Generated
        public B media(@NonNull List<InputPaidMedia> media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return (B)this.self();
        }

        @Generated
        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return (B)this.self();
        }

        @Generated
        public B captionEntities(List<MessageEntity> captionEntities) {
            this.captionEntities = captionEntities;
            return (B)this.self();
        }

        @Generated
        public B showCaptionAboveMedia(Boolean showCaptionAboveMedia) {
            this.showCaptionAboveMedia = showCaptionAboveMedia;
            return (B)this.self();
        }

        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @Generated
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @Generated
        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @Generated
        public B payload(String payload) {
            this.payload = payload;
            return (B)this.self();
        }

        @Generated
        public B allowPaidBroadcast(Boolean allowPaidBroadcast) {
            this.allowPaidBroadcast = allowPaidBroadcast;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendPaidMedia.SendPaidMediaBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", starCount=" + this.starCount + ", media=" + this.media + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ", showCaptionAboveMedia=" + this.showCaptionAboveMedia + ", disableNotification=" + this.disableNotification + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ", replyMarkup=" + this.replyMarkup + ", businessConnectionId=" + this.businessConnectionId + ", payload=" + this.payload + ", allowPaidBroadcast=" + this.allowPaidBroadcast + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendPaidMediaBuilderImpl
    extends SendPaidMediaBuilder<SendPaidMedia, SendPaidMediaBuilderImpl> {
        @Generated
        private SendPaidMediaBuilderImpl() {
        }

        @Override
        @Generated
        protected SendPaidMediaBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendPaidMedia build() {
            return new SendPaidMedia(this);
        }
    }
}

