/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.forum;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.forum.ForumTopic;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=CreateForumTopicBuilderImpl.class)
public class CreateForumTopic
extends BotApiMethod<ForumTopic> {
    public static final String PATH = "createForumTopic";
    private static final String CHATID_FIELD = "chat_id";
    private static final String NAME_FIELD = "name";
    private static final String ICONCOLOR_FIELD = "icon_color";
    private static final String ICONCUSTOMEMOJIID_FIELD = "icon_custom_emoji_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="name")
    @NonNull
    private String name;
    @JsonProperty(value="icon_color")
    private Integer iconColor;
    @JsonProperty(value="icon_custom_emoji_id")
    private String iconCustomEmojiId;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.name.isEmpty() || this.name.length() > 128) {
            throw new TelegramApiValidationException("Name must be between 1 and 128 characters", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ForumTopic deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, ForumTopic.class);
    }

    protected CreateForumTopic(CreateForumTopicBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.name = b.name;
        if (this.name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.iconColor = b.iconColor;
        this.iconCustomEmojiId = b.iconCustomEmojiId;
    }

    public static CreateForumTopicBuilder<?, ?> builder() {
        return new CreateForumTopicBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateForumTopic)) {
            return false;
        }
        CreateForumTopic other = (CreateForumTopic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$iconColor = this.getIconColor();
        Integer other$iconColor = other.getIconColor();
        if (this$iconColor == null ? other$iconColor != null : !((Object)this$iconColor).equals(other$iconColor)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$iconCustomEmojiId = this.getIconCustomEmojiId();
        String other$iconCustomEmojiId = other.getIconCustomEmojiId();
        return !(this$iconCustomEmojiId == null ? other$iconCustomEmojiId != null : !this$iconCustomEmojiId.equals(other$iconCustomEmojiId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateForumTopic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $iconColor = this.getIconColor();
        result = result * 59 + ($iconColor == null ? 43 : ((Object)$iconColor).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $iconCustomEmojiId = this.getIconCustomEmojiId();
        result = result * 59 + ($iconCustomEmojiId == null ? 43 : $iconCustomEmojiId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Integer getIconColor() {
        return this.iconColor;
    }

    public String getIconCustomEmojiId() {
        return this.iconCustomEmojiId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="name")
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="icon_color")
    public void setIconColor(Integer iconColor) {
        this.iconColor = iconColor;
    }

    @JsonProperty(value="icon_custom_emoji_id")
    public void setIconCustomEmojiId(String iconCustomEmojiId) {
        this.iconCustomEmojiId = iconCustomEmojiId;
    }

    public String toString() {
        return "CreateForumTopic(chatId=" + this.getChatId() + ", name=" + this.getName() + ", iconColor=" + this.getIconColor() + ", iconCustomEmojiId=" + this.getIconCustomEmojiId() + ")";
    }

    public CreateForumTopic(@NonNull String chatId, @NonNull String name) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.chatId = chatId;
        this.name = name;
    }

    public CreateForumTopic(@NonNull String chatId, @NonNull String name, Integer iconColor, String iconCustomEmojiId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.chatId = chatId;
        this.name = name;
        this.iconColor = iconColor;
        this.iconCustomEmojiId = iconCustomEmojiId;
    }

    public static abstract class CreateForumTopicBuilder<C extends CreateForumTopic, B extends CreateForumTopicBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<ForumTopic, C, B> {
        private String chatId;
        private String name;
        private Integer iconColor;
        private String iconCustomEmojiId;

        public CreateForumTopicBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="name")
        public B name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return (B)this.self();
        }

        @JsonProperty(value="icon_color")
        public B iconColor(Integer iconColor) {
            this.iconColor = iconColor;
            return (B)this.self();
        }

        @JsonProperty(value="icon_custom_emoji_id")
        public B iconCustomEmojiId(String iconCustomEmojiId) {
            this.iconCustomEmojiId = iconCustomEmojiId;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "CreateForumTopic.CreateForumTopicBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", name=" + this.name + ", iconColor=" + this.iconColor + ", iconCustomEmojiId=" + this.iconCustomEmojiId + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class CreateForumTopicBuilderImpl
    extends CreateForumTopicBuilder<CreateForumTopic, CreateForumTopicBuilderImpl> {
        private CreateForumTopicBuilderImpl() {
        }

        @Override
        protected CreateForumTopicBuilderImpl self() {
            return this;
        }

        @Override
        public CreateForumTopic build() {
            return new CreateForumTopic(this);
        }
    }
}

