package org.telegram.telegrambots.meta.api.objects.business;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import lombok.extern.jackson.Jacksonized;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;

/**
 * @author Ruben Bermudez
 * @version 7.2
 * Describes an interval of time during which a business is open.
 */
@EqualsAndHashCode(callSuper = false)
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@SuperBuilder
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public class BusinessOpeningHoursInterval implements BotApiObject {
    private static final String OPENING_MINUTE_FIELD = "opening_minute";
    private static final String CLOSING_MINUTE_FIELD = "closing_minute";

    /**
     * The minute's sequence number in a week, starting on Monday, marking the start of the time interval during which the business is open; 0 - 7 24 60
     */
    @JsonProperty(OPENING_MINUTE_FIELD)
    @NonNull
    private Integer openingMinute;
    /**
     * The minute's sequence number in a week, starting on Monday, marking the end of the time interval during which the business is open; 0 - 8 24 60
     */
    @JsonProperty(CLOSING_MINUTE_FIELD)
    @NonNull
    private Integer closingMinute;
}
