/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaBotMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SendAudioBuilderImpl.class)
public class SendAudio
extends SendMediaBotMethod<Message> {
    public static final String PATH = "sendaudio";
    public static final String DURATION_FIELD = "duration";
    public static final String AUDIO_FIELD = "audio";
    public static final String PERFORMER_FIELD = "performer";
    public static final String TITLE_FIELD = "title";
    public static final String CAPTION_FIELD = "caption";
    public static final String PARSE_MODE_FIELD = "parse_mode";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    public static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    public static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    @NonNull
    private String chatId;
    private Integer messageThreadId;
    @NonNull
    private InputFile audio;
    private Integer replyToMessageId;
    private Boolean disableNotification;
    private ReplyKeyboard replyMarkup;
    private String performer;
    private String title;
    private String caption;
    private String parseMode;
    private Integer duration;
    private InputFile thumbnail;
    private List<MessageEntity> captionEntities;
    private Boolean allowSendingWithoutReply;
    private Boolean protectContent;
    private ReplyParameters replyParameters;
    private String businessConnectionId;
    private String messageEffectId;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        this.audio.validate();
        if (this.thumbnail != null) {
            this.thumbnail.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public InputFile getFile() {
        return this.audio;
    }

    @Override
    public String getFileField() {
        return AUDIO_FIELD;
    }

    protected SendAudio(SendAudioBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.audio = b.audio;
        if (this.audio == null) {
            throw new NullPointerException("audio is marked non-null but is null");
        }
        this.replyToMessageId = b.replyToMessageId;
        this.disableNotification = b.disableNotification;
        this.replyMarkup = b.replyMarkup;
        this.performer = b.performer;
        this.title = b.title;
        this.caption = b.caption;
        this.parseMode = b.parseMode;
        this.duration = b.duration;
        this.thumbnail = b.thumbnail;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
        this.businessConnectionId = b.businessConnectionId;
        this.messageEffectId = b.messageEffectId;
    }

    public static SendAudioBuilder<?, ?> builder() {
        return new SendAudioBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendAudio)) {
            return false;
        }
        SendAudio other = (SendAudio)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputFile this$audio = this.getAudio();
        InputFile other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$performer = this.getPerformer();
        String other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        String this$messageEffectId = this.getMessageEffectId();
        String other$messageEffectId = other.getMessageEffectId();
        return !(this$messageEffectId == null ? other$messageEffectId != null : !this$messageEffectId.equals(other$messageEffectId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendAudio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputFile $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : ((Object)$audio).hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        String $messageEffectId = this.getMessageEffectId();
        result = result * 59 + ($messageEffectId == null ? 43 : $messageEffectId.hashCode());
        return result;
    }

    @Override
    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @Override
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public InputFile getAudio() {
        return this.audio;
    }

    @Override
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Override
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Override
    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Override
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @Override
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Override
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @Override
    public String getMessageEffectId() {
        return this.messageEffectId;
    }

    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    public void setAudio(@NonNull InputFile audio) {
        if (audio == null) {
            throw new NullPointerException("audio is marked non-null but is null");
        }
        this.audio = audio;
    }

    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    public void setMessageEffectId(String messageEffectId) {
        this.messageEffectId = messageEffectId;
    }

    public String toString() {
        return "SendAudio(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", audio=" + this.getAudio() + ", replyToMessageId=" + this.getReplyToMessageId() + ", disableNotification=" + this.getDisableNotification() + ", replyMarkup=" + this.getReplyMarkup() + ", performer=" + this.getPerformer() + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", duration=" + this.getDuration() + ", thumbnail=" + this.getThumbnail() + ", captionEntities=" + this.getCaptionEntities() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ", businessConnectionId=" + this.getBusinessConnectionId() + ", messageEffectId=" + this.getMessageEffectId() + ")";
    }

    public SendAudio(@NonNull String chatId, @NonNull InputFile audio) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (audio == null) {
            throw new NullPointerException("audio is marked non-null but is null");
        }
        this.chatId = chatId;
        this.audio = audio;
    }

    public SendAudio(@NonNull String chatId, Integer messageThreadId, @NonNull InputFile audio, Integer replyToMessageId, Boolean disableNotification, ReplyKeyboard replyMarkup, String performer, String title, String caption, String parseMode, Integer duration, InputFile thumbnail, List<MessageEntity> captionEntities, Boolean allowSendingWithoutReply, Boolean protectContent, ReplyParameters replyParameters, String businessConnectionId, String messageEffectId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (audio == null) {
            throw new NullPointerException("audio is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.audio = audio;
        this.replyToMessageId = replyToMessageId;
        this.disableNotification = disableNotification;
        this.replyMarkup = replyMarkup;
        this.performer = performer;
        this.title = title;
        this.caption = caption;
        this.parseMode = parseMode;
        this.duration = duration;
        this.thumbnail = thumbnail;
        this.captionEntities = captionEntities;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
        this.businessConnectionId = businessConnectionId;
        this.messageEffectId = messageEffectId;
    }

    public static abstract class SendAudioBuilder<C extends SendAudio, B extends SendAudioBuilder<C, B>>
    extends SendMediaBotMethod.SendMediaBotMethodBuilder<Message, C, B> {
        private String chatId;
        private Integer messageThreadId;
        private InputFile audio;
        private Integer replyToMessageId;
        private Boolean disableNotification;
        private ReplyKeyboard replyMarkup;
        private String performer;
        private String title;
        private String caption;
        private String parseMode;
        private Integer duration;
        private InputFile thumbnail;
        private ArrayList<MessageEntity> captionEntities;
        private Boolean allowSendingWithoutReply;
        private Boolean protectContent;
        private ReplyParameters replyParameters;
        private String businessConnectionId;
        private String messageEffectId;

        public SendAudioBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        public B audio(@NonNull InputFile audio) {
            if (audio == null) {
                throw new NullPointerException("audio is marked non-null but is null");
            }
            this.audio = audio;
            return (B)this.self();
        }

        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        public B performer(String performer) {
            this.performer = performer;
            return (B)this.self();
        }

        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return (B)this.self();
        }

        public B duration(Integer duration) {
            this.duration = duration;
            return (B)this.self();
        }

        public B thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return (B)this.self();
        }

        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return (B)this.self();
        }

        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return (B)this.self();
        }

        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        public B messageEffectId(String messageEffectId) {
            this.messageEffectId = messageEffectId;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SendAudio.SendAudioBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", audio=" + this.audio + ", replyToMessageId=" + this.replyToMessageId + ", disableNotification=" + this.disableNotification + ", replyMarkup=" + this.replyMarkup + ", performer=" + this.performer + ", title=" + this.title + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", duration=" + this.duration + ", thumbnail=" + this.thumbnail + ", captionEntities=" + this.captionEntities + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ", businessConnectionId=" + this.businessConnectionId + ", messageEffectId=" + this.messageEffectId + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SendAudioBuilderImpl
    extends SendAudioBuilder<SendAudio, SendAudioBuilderImpl> {
        private SendAudioBuilderImpl() {
        }

        @Override
        protected SendAudioBuilderImpl self() {
            return this;
        }

        @Override
        public SendAudio build() {
            return new SendAudio(this);
        }
    }
}

