/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.games;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.PhotoSize;
import org.telegram.telegrambots.meta.api.objects.games.Animation;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=GameBuilderImpl.class)
public class Game
implements BotApiObject {
    private static final String TITLE_FIELD = "title";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String PHOTO_FIELD = "photo";
    private static final String ANIMATION_FIELD = "animation";
    private static final String TEXT_FIELD = "text";
    private static final String TEXTENTITIES_FIELD = "text_entities";
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="description")
    @NonNull
    private String description;
    @JsonProperty(value="photo")
    @NonNull
    private List<PhotoSize> photo;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="text_entities")
    private List<MessageEntity> entities;
    @JsonProperty(value="animation")
    private Animation animation;

    public boolean hasEntities() {
        return this.entities != null && !this.entities.isEmpty();
    }

    protected Game(GameBuilder<?, ?> b) {
        this.title = b.title;
        if (this.title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.description = b.description;
        if (this.description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.photo = b.photo;
        if (this.photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
        this.text = b.text;
        this.entities = b.entities;
        this.animation = b.animation;
    }

    public static GameBuilder<?, ?> builder() {
        return new GameBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Game)) {
            return false;
        }
        Game other = (Game)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<PhotoSize> this$photo = this.getPhoto();
        List<PhotoSize> other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !((Object)this$photo).equals(other$photo)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<MessageEntity> this$entities = this.getEntities();
        List<MessageEntity> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        Animation this$animation = this.getAnimation();
        Animation other$animation = other.getAnimation();
        return !(this$animation == null ? other$animation != null : !((Object)this$animation).equals(other$animation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Game;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<PhotoSize> $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : ((Object)$photo).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<MessageEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        Animation $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)$animation).hashCode());
        return result;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public List<PhotoSize> getPhoto() {
        return this.photo;
    }

    public String getText() {
        return this.text;
    }

    public List<MessageEntity> getEntities() {
        return this.entities;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="description")
    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    @JsonProperty(value="photo")
    public void setPhoto(@NonNull List<PhotoSize> photo) {
        if (photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
        this.photo = photo;
    }

    @JsonProperty(value="text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="text_entities")
    public void setEntities(List<MessageEntity> entities) {
        this.entities = entities;
    }

    @JsonProperty(value="animation")
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public String toString() {
        return "Game(title=" + this.getTitle() + ", description=" + this.getDescription() + ", photo=" + this.getPhoto() + ", text=" + this.getText() + ", entities=" + this.getEntities() + ", animation=" + this.getAnimation() + ")";
    }

    public Game(@NonNull String title, @NonNull String description, @NonNull List<PhotoSize> photo) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
        this.title = title;
        this.description = description;
        this.photo = photo;
    }

    public Game(@NonNull String title, @NonNull String description, @NonNull List<PhotoSize> photo, String text, List<MessageEntity> entities, Animation animation) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
        this.title = title;
        this.description = description;
        this.photo = photo;
        this.text = text;
        this.entities = entities;
        this.animation = animation;
    }

    public static abstract class GameBuilder<C extends Game, B extends GameBuilder<C, B>> {
        private String title;
        private String description;
        private List<PhotoSize> photo;
        private String text;
        private List<MessageEntity> entities;
        private Animation animation;

        @JsonProperty(value="title")
        public B title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="description")
        public B description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this.self();
        }

        @JsonProperty(value="photo")
        public B photo(@NonNull List<PhotoSize> photo) {
            if (photo == null) {
                throw new NullPointerException("photo is marked non-null but is null");
            }
            this.photo = photo;
            return this.self();
        }

        @JsonProperty(value="text")
        public B text(String text) {
            this.text = text;
            return this.self();
        }

        @JsonProperty(value="text_entities")
        public B entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this.self();
        }

        @JsonProperty(value="animation")
        public B animation(Animation animation) {
            this.animation = animation;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Game.GameBuilder(title=" + this.title + ", description=" + this.description + ", photo=" + this.photo + ", text=" + this.text + ", entities=" + this.entities + ", animation=" + this.animation + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class GameBuilderImpl
    extends GameBuilder<Game, GameBuilderImpl> {
        private GameBuilderImpl() {
        }

        @Override
        protected GameBuilderImpl self() {
            return this;
        }

        @Override
        public Game build() {
            return new Game(this);
        }
    }
}

