/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InputMediaPhotoBuilderImpl.class)
public class InputMediaPhoto
extends InputMedia {
    private static final String TYPE = "photo";
    private static final String HAS_SPOILER_FIELD = "has_spoiler";
    private static final String SHOW_CAPTION_ABOVE_MEDIA_FIELD = "show_caption_above_media";
    @JsonProperty(value="has_spoiler")
    private Boolean hasSpoiler;
    @JsonProperty(value="show_caption_above_media")
    private Boolean showCaptionAboveMedia;

    public InputMediaPhoto(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaPhoto(File mediaFile, String fileName) {
        this.setMedia(mediaFile, fileName);
    }

    public InputMediaPhoto(InputStream mediaStream, String fileName) {
        this.setMedia(mediaStream, fileName);
    }

    public InputMediaPhoto(@NonNull String media, String caption, String parseMode, List<MessageEntity> captionEntities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, Boolean hasSpoiler) {
        super(media, caption, parseMode, captionEntities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.hasSpoiler = hasSpoiler;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    protected InputMediaPhoto(InputMediaPhotoBuilder<?, ?> b) {
        super(b);
        this.hasSpoiler = b.hasSpoiler;
        this.showCaptionAboveMedia = b.showCaptionAboveMedia;
    }

    public static InputMediaPhotoBuilder<?, ?> builder() {
        return new InputMediaPhotoBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaPhoto)) {
            return false;
        }
        InputMediaPhoto other = (InputMediaPhoto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$hasSpoiler = this.getHasSpoiler();
        Boolean other$hasSpoiler = other.getHasSpoiler();
        if (this$hasSpoiler == null ? other$hasSpoiler != null : !((Object)this$hasSpoiler).equals(other$hasSpoiler)) {
            return false;
        }
        Boolean this$showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        Boolean other$showCaptionAboveMedia = other.getShowCaptionAboveMedia();
        return !(this$showCaptionAboveMedia == null ? other$showCaptionAboveMedia != null : !((Object)this$showCaptionAboveMedia).equals(other$showCaptionAboveMedia));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaPhoto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $hasSpoiler = this.getHasSpoiler();
        result = result * 59 + ($hasSpoiler == null ? 43 : ((Object)$hasSpoiler).hashCode());
        Boolean $showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        result = result * 59 + ($showCaptionAboveMedia == null ? 43 : ((Object)$showCaptionAboveMedia).hashCode());
        return result;
    }

    public Boolean getHasSpoiler() {
        return this.hasSpoiler;
    }

    public Boolean getShowCaptionAboveMedia() {
        return this.showCaptionAboveMedia;
    }

    @JsonProperty(value="has_spoiler")
    public void setHasSpoiler(Boolean hasSpoiler) {
        this.hasSpoiler = hasSpoiler;
    }

    @JsonProperty(value="show_caption_above_media")
    public void setShowCaptionAboveMedia(Boolean showCaptionAboveMedia) {
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    @Override
    public String toString() {
        return "InputMediaPhoto(hasSpoiler=" + this.getHasSpoiler() + ", showCaptionAboveMedia=" + this.getShowCaptionAboveMedia() + ")";
    }

    public static abstract class InputMediaPhotoBuilder<C extends InputMediaPhoto, B extends InputMediaPhotoBuilder<C, B>>
    extends InputMedia.InputMediaBuilder<C, B> {
        private Boolean hasSpoiler;
        private Boolean showCaptionAboveMedia;

        @JsonProperty(value="has_spoiler")
        public B hasSpoiler(Boolean hasSpoiler) {
            this.hasSpoiler = hasSpoiler;
            return (B)this.self();
        }

        @JsonProperty(value="show_caption_above_media")
        public B showCaptionAboveMedia(Boolean showCaptionAboveMedia) {
            this.showCaptionAboveMedia = showCaptionAboveMedia;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InputMediaPhoto.InputMediaPhotoBuilder(super=" + super.toString() + ", hasSpoiler=" + this.hasSpoiler + ", showCaptionAboveMedia=" + this.showCaptionAboveMedia + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InputMediaPhotoBuilderImpl
    extends InputMediaPhotoBuilder<InputMediaPhoto, InputMediaPhotoBuilderImpl> {
        private InputMediaPhotoBuilderImpl() {
        }

        @Override
        protected InputMediaPhotoBuilderImpl self() {
            return this;
        }

        @Override
        public InputMediaPhoto build() {
            return new InputMediaPhoto(this);
        }
    }
}

