/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.webapp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=WebAppInfoBuilderImpl.class)
public class WebAppInfo
implements Validable,
BotApiObject {
    private static final String URL_FIELD = "url";
    @JsonProperty(value="url")
    @NonNull
    private String url;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.url.isEmpty()) {
            throw new TelegramApiValidationException("Url can't be empty", this);
        }
    }

    protected WebAppInfo(WebAppInfoBuilder<?, ?> b) {
        this.url = b.url;
        if (this.url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
    }

    public static WebAppInfoBuilder<?, ?> builder() {
        return new WebAppInfoBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebAppInfo)) {
            return false;
        }
        WebAppInfo other = (WebAppInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebAppInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public String toString() {
        return "WebAppInfo(url=" + this.getUrl() + ")";
    }

    public WebAppInfo(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public static abstract class WebAppInfoBuilder<C extends WebAppInfo, B extends WebAppInfoBuilder<C, B>> {
        private String url;

        @JsonProperty(value="url")
        public B url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "WebAppInfo.WebAppInfoBuilder(url=" + this.url + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class WebAppInfoBuilderImpl
    extends WebAppInfoBuilder<WebAppInfo, WebAppInfoBuilderImpl> {
        private WebAppInfoBuilderImpl() {
        }

        @Override
        protected WebAppInfoBuilderImpl self() {
            return this;
        }

        @Override
        public WebAppInfo build() {
            return new WebAppInfo(this);
        }
    }
}

