/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodSerializable;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class EditMessageCaption
extends BotApiMethodSerializable {
    public static final String PATH = "editmessagecaption";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String CAPTION_FIELD = "caption";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    private static final String SHOW_CAPTION_ABOVE_MEDIA_FIELD = "show_caption_above_media";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;
    @JsonProperty(value="show_caption_above_media")
    private Boolean showCaptionAboveMedia;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;

    public void setChatId(Long chatId) {
        this.chatId = chatId == null ? null : chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Serializable deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponseMessageOrBoolean(answer);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null || this.chatId.isEmpty()) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    @Generated
    public static EditMessageCaptionBuilder builder() {
        return new EditMessageCaptionBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditMessageCaption)) {
            return false;
        }
        EditMessageCaption other = (EditMessageCaption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        Boolean other$showCaptionAboveMedia = other.getShowCaptionAboveMedia();
        if (this$showCaptionAboveMedia == null ? other$showCaptionAboveMedia != null : !((Object)this$showCaptionAboveMedia).equals(other$showCaptionAboveMedia)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        if (this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        return !(this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditMessageCaption;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        result = result * 59 + ($showCaptionAboveMedia == null ? 43 : ((Object)$showCaptionAboveMedia).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        return result;
    }

    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Generated
    public Boolean getShowCaptionAboveMedia() {
        return this.showCaptionAboveMedia;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    @Generated
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="caption")
    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    @Generated
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @JsonProperty(value="show_caption_above_media")
    @Generated
    public void setShowCaptionAboveMedia(Boolean showCaptionAboveMedia) {
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @Generated
    public String toString() {
        return "EditMessageCaption(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", caption=" + this.getCaption() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ", showCaptionAboveMedia=" + this.getShowCaptionAboveMedia() + ", businessConnectionId=" + this.getBusinessConnectionId() + ")";
    }

    @Generated
    public EditMessageCaption() {
    }

    @Generated
    public EditMessageCaption(String chatId, Integer messageId, String inlineMessageId, String caption, InlineKeyboardMarkup replyMarkup, String parseMode, List<MessageEntity> captionEntities, Boolean showCaptionAboveMedia, String businessConnectionId) {
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.caption = caption;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
        this.showCaptionAboveMedia = showCaptionAboveMedia;
        this.businessConnectionId = businessConnectionId;
    }

    public static class EditMessageCaptionBuilder {
        @Generated
        private String chatId;
        @Generated
        private Integer messageId;
        @Generated
        private String inlineMessageId;
        @Generated
        private String caption;
        @Generated
        private InlineKeyboardMarkup replyMarkup;
        @Generated
        private String parseMode;
        @Generated
        private ArrayList<MessageEntity> captionEntities;
        @Generated
        private Boolean showCaptionAboveMedia;
        @Generated
        private String businessConnectionId;

        public EditMessageCaptionBuilder chatId(Long chatId) {
            this.chatId = chatId == null ? null : chatId.toString();
            return this;
        }

        @Generated
        EditMessageCaptionBuilder() {
        }

        @JsonProperty(value="chat_id")
        @Generated
        public EditMessageCaptionBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_id")
        @Generated
        public EditMessageCaptionBuilder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        @JsonProperty(value="inline_message_id")
        @Generated
        public EditMessageCaptionBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        @JsonProperty(value="caption")
        @Generated
        public EditMessageCaptionBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public EditMessageCaptionBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public EditMessageCaptionBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        @Generated
        public EditMessageCaptionBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        @JsonProperty(value="caption_entities")
        @Generated
        public EditMessageCaptionBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        @Generated
        public EditMessageCaptionBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        @JsonProperty(value="show_caption_above_media")
        @Generated
        public EditMessageCaptionBuilder showCaptionAboveMedia(Boolean showCaptionAboveMedia) {
            this.showCaptionAboveMedia = showCaptionAboveMedia;
            return this;
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public EditMessageCaptionBuilder businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return this;
        }

        @Generated
        public EditMessageCaption build() {
            return new EditMessageCaption(this.chatId, this.messageId, this.inlineMessageId, this.caption, this.replyMarkup, this.parseMode, switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.captionEntities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
            }, this.showCaptionAboveMedia, this.businessConnectionId);
        }

        @Generated
        public String toString() {
            return "EditMessageCaption.EditMessageCaptionBuilder(chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", caption=" + this.caption + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ", showCaptionAboveMedia=" + this.showCaptionAboveMedia + ", businessConnectionId=" + this.businessConnectionId + ")";
        }
    }
}

