/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=DeleteMessagesBuilderImpl.class)
public class DeleteMessages
extends BotApiMethodBoolean {
    private static final String PATH = "deleteMessages";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_IDS_FIELD = "message_ids";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_ids")
    @NonNull
    private List<Integer> messageIds;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageIds.isEmpty() || this.messageIds.size() > 100) {
            throw new TelegramApiValidationException("MessageIds parameter items count must be between 1 and 100", this);
        }
    }

    @Generated
    protected DeleteMessages(DeleteMessagesBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        List<Object> messageIds = switch (b.messageIds == null ? 0 : b.messageIds.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.messageIds.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Integer>(b.messageIds));
        };
        this.messageIds = messageIds;
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
    }

    @Generated
    public static DeleteMessagesBuilder<?, ?> builder() {
        return new DeleteMessagesBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteMessages)) {
            return false;
        }
        DeleteMessages other = (DeleteMessages)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        List<Integer> this$messageIds = this.getMessageIds();
        List<Integer> other$messageIds = other.getMessageIds();
        return !(this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeleteMessages;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        List<Integer> $messageIds = this.getMessageIds();
        result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public List<Integer> getMessageIds() {
        return this.messageIds;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_ids")
    @Generated
    public void setMessageIds(@NonNull List<Integer> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.messageIds = messageIds;
    }

    @Generated
    public String toString() {
        return "DeleteMessages(chatId=" + this.getChatId() + ", messageIds=" + this.getMessageIds() + ")";
    }

    @Generated
    public DeleteMessages(@NonNull String chatId, @NonNull List<Integer> messageIds) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageIds = messageIds;
    }

    public static abstract class DeleteMessagesBuilder<C extends DeleteMessages, B extends DeleteMessagesBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private ArrayList<Integer> messageIds;

        public DeleteMessagesBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @Generated
        public B messageId(Integer messageId) {
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.add(messageId);
            return (B)this.self();
        }

        @JsonProperty(value="message_ids")
        @Generated
        public B messageIds(Collection<? extends Integer> messageIds) {
            if (messageIds == null) {
                throw new NullPointerException("messageIds cannot be null");
            }
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.addAll(messageIds);
            return (B)this.self();
        }

        @Generated
        public B clearMessageIds() {
            if (this.messageIds != null) {
                this.messageIds.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DeleteMessages.DeleteMessagesBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageIds=" + this.messageIds + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class DeleteMessagesBuilderImpl
    extends DeleteMessagesBuilder<DeleteMessages, DeleteMessagesBuilderImpl> {
        @Generated
        private DeleteMessagesBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteMessagesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeleteMessages build() {
            return new DeleteMessages(this);
        }
    }
}

