/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media.paid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.File;
import java.io.InputStream;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.media.paid.InputPaidMediaPhoto;
import org.telegram.telegrambots.meta.api.objects.media.paid.InputPaidMediaVideo;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=InputPaidMediaPhoto.class, name="photo"), @JsonSubTypes.Type(value=InputPaidMediaVideo.class, name="video")})
public abstract class InputPaidMedia
implements Validable,
BotApiObject {
    public static final String TYPE_FIELD = "type";
    public static final String MEDIA_FIELD = "media";
    @JsonProperty(value="media")
    @NonNull
    private String media;
    @JsonIgnore
    private boolean isNewMedia;
    @JsonIgnore
    private String mediaName;
    @JsonIgnore
    private File newMediaFile;
    @JsonIgnore
    private InputStream newMediaStream;

    @JsonIgnore
    public boolean isNewMedia() {
        return this.isNewMedia;
    }

    public void setMedia(String media) {
        this.media = media;
        this.isNewMedia = false;
    }

    public void setMedia(File mediaFile, String fileName) {
        this.newMediaFile = mediaFile;
        this.isNewMedia = true;
        this.mediaName = fileName;
        this.media = "attach://" + fileName;
    }

    public void setMedia(InputStream mediaStream, String fileName) {
        this.newMediaStream = mediaStream;
        this.isNewMedia = true;
        this.mediaName = fileName;
        this.media = "attach://" + fileName;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.isNewMedia) {
            if (this.mediaName == null || this.mediaName.isEmpty()) {
                throw new TelegramApiValidationException("Media name can't be empty", this);
            }
            if (this.newMediaFile == null && this.newMediaStream == null) {
                throw new TelegramApiValidationException("Media can't be empty", this);
            }
        } else if (this.media.isEmpty()) {
            throw new TelegramApiValidationException("Media can't be empty", this);
        }
    }

    @JsonProperty(value="type")
    public abstract String getType();

    @Generated
    protected InputPaidMedia(InputPaidMediaBuilder<?, ?> b) {
        this.media = b.media;
        if (this.media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.isNewMedia = b.isNewMedia;
        this.mediaName = b.mediaName;
        this.newMediaFile = b.newMediaFile;
        this.newMediaStream = b.newMediaStream;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputPaidMedia)) {
            return false;
        }
        InputPaidMedia other = (InputPaidMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNewMedia() != other.isNewMedia()) {
            return false;
        }
        String this$media = this.getMedia();
        String other$media = other.getMedia();
        if (this$media == null ? other$media != null : !this$media.equals(other$media)) {
            return false;
        }
        String this$mediaName = this.getMediaName();
        String other$mediaName = other.getMediaName();
        if (this$mediaName == null ? other$mediaName != null : !this$mediaName.equals(other$mediaName)) {
            return false;
        }
        File this$newMediaFile = this.getNewMediaFile();
        File other$newMediaFile = other.getNewMediaFile();
        if (this$newMediaFile == null ? other$newMediaFile != null : !((Object)this$newMediaFile).equals(other$newMediaFile)) {
            return false;
        }
        InputStream this$newMediaStream = this.getNewMediaStream();
        InputStream other$newMediaStream = other.getNewMediaStream();
        return !(this$newMediaStream == null ? other$newMediaStream != null : !this$newMediaStream.equals(other$newMediaStream));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputPaidMedia;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNewMedia() ? 79 : 97);
        String $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : $media.hashCode());
        String $mediaName = this.getMediaName();
        result = result * 59 + ($mediaName == null ? 43 : $mediaName.hashCode());
        File $newMediaFile = this.getNewMediaFile();
        result = result * 59 + ($newMediaFile == null ? 43 : ((Object)$newMediaFile).hashCode());
        InputStream $newMediaStream = this.getNewMediaStream();
        result = result * 59 + ($newMediaStream == null ? 43 : $newMediaStream.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getMedia() {
        return this.media;
    }

    @Generated
    public String getMediaName() {
        return this.mediaName;
    }

    @Generated
    public File getNewMediaFile() {
        return this.newMediaFile;
    }

    @Generated
    public InputStream getNewMediaStream() {
        return this.newMediaStream;
    }

    @JsonIgnore
    @Generated
    public void setNewMedia(boolean isNewMedia) {
        this.isNewMedia = isNewMedia;
    }

    @JsonIgnore
    @Generated
    public void setMediaName(String mediaName) {
        this.mediaName = mediaName;
    }

    @JsonIgnore
    @Generated
    public void setNewMediaFile(File newMediaFile) {
        this.newMediaFile = newMediaFile;
    }

    @JsonIgnore
    @Generated
    public void setNewMediaStream(InputStream newMediaStream) {
        this.newMediaStream = newMediaStream;
    }

    @Generated
    public String toString() {
        return "InputPaidMedia(media=" + this.getMedia() + ", isNewMedia=" + this.isNewMedia() + ", mediaName=" + this.getMediaName() + ", newMediaFile=" + this.getNewMediaFile() + ", newMediaStream=" + this.getNewMediaStream() + ")";
    }

    @Generated
    protected InputPaidMedia() {
    }

    @Generated
    public InputPaidMedia(@NonNull String media) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
    }

    @Generated
    public InputPaidMedia(@NonNull String media, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
        this.isNewMedia = isNewMedia;
        this.mediaName = mediaName;
        this.newMediaFile = newMediaFile;
        this.newMediaStream = newMediaStream;
    }

    public static abstract class InputPaidMediaBuilder<C extends InputPaidMedia, B extends InputPaidMediaBuilder<C, B>> {
        @Generated
        private String media;
        @Generated
        private boolean isNewMedia;
        @Generated
        private String mediaName;
        @Generated
        private File newMediaFile;
        @Generated
        private InputStream newMediaStream;

        @JsonIgnore
        public B media(@NonNull File mediaFile, @NonNull String fileName) {
            if (mediaFile == null) {
                throw new NullPointerException("mediaFile is marked non-null but is null");
            }
            if (fileName == null) {
                throw new NullPointerException("fileName is marked non-null but is null");
            }
            this.newMediaFile = mediaFile;
            this.isNewMedia = true;
            this.mediaName = fileName;
            this.media = "attach://" + fileName;
            return this.self();
        }

        @JsonIgnore
        public B media(@NonNull InputStream mediaStream, @NonNull String fileName) {
            if (mediaStream == null) {
                throw new NullPointerException("mediaStream is marked non-null but is null");
            }
            if (fileName == null) {
                throw new NullPointerException("fileName is marked non-null but is null");
            }
            this.newMediaStream = mediaStream;
            this.isNewMedia = true;
            this.mediaName = fileName;
            this.media = "attach://" + fileName;
            return this.self();
        }

        @JsonProperty(value="media")
        public B media(@NonNull String media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            this.isNewMedia = false;
            return this.self();
        }

        @JsonIgnore
        private B isNewMedia(boolean isNewMedia) {
            return this.self();
        }

        @JsonIgnore
        private B mediaName(String mediaName) {
            return this.self();
        }

        @JsonIgnore
        private B newMediaFile(File newMediaFile) {
            return this.self();
        }

        @JsonIgnore
        private B newMediaStream(InputStream newMediaStream) {
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InputPaidMedia.InputPaidMediaBuilder(media=" + this.media + ", isNewMedia=" + this.isNewMedia + ", mediaName=" + this.mediaName + ", newMediaFile=" + this.newMediaFile + ", newMediaStream=" + this.newMediaStream + ")";
        }
    }
}

