/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SetPassportDataErrorsBuilderImpl.class)
public class SetPassportDataErrors
extends BotApiMethodBoolean {
    public static final String PATH = "setPassportDataErrors";
    private static final String USERID_FIELD = "user_id";
    private static final String ERRORS_FIELD = "errors";
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="errors")
    @NonNull
    private List<PassportElementError> errors;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.errors.isEmpty()) {
            throw new TelegramApiValidationException("Errors can't be empty", this);
        }
    }

    @Generated
    protected SetPassportDataErrors(SetPassportDataErrorsBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        List<Object> errors = switch (b.errors == null ? 0 : b.errors.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.errors.get(0));
            default -> Collections.unmodifiableList(new ArrayList<PassportElementError>(b.errors));
        };
        this.errors = errors;
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
    }

    @Generated
    public static SetPassportDataErrorsBuilder<?, ?> builder() {
        return new SetPassportDataErrorsBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetPassportDataErrors)) {
            return false;
        }
        SetPassportDataErrors other = (SetPassportDataErrors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        List<PassportElementError> this$errors = this.getErrors();
        List<PassportElementError> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetPassportDataErrors;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        List<PassportElementError> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    @Generated
    public List<PassportElementError> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="errors")
    @Generated
    public void setErrors(@NonNull List<PassportElementError> errors) {
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        this.errors = errors;
    }

    @Generated
    public String toString() {
        return "SetPassportDataErrors(userId=" + this.getUserId() + ", errors=" + this.getErrors() + ")";
    }

    @Generated
    public SetPassportDataErrors(@NonNull Long userId, @NonNull List<PassportElementError> errors) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        this.userId = userId;
        this.errors = errors;
    }

    @Generated
    public static abstract class SetPassportDataErrorsBuilder<C extends SetPassportDataErrors, B extends SetPassportDataErrorsBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private Long userId;
        @Generated
        private ArrayList<PassportElementError> errors;

        @JsonProperty(value="user_id")
        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @Generated
        public B error(PassportElementError error) {
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.add(error);
            return (B)this.self();
        }

        @JsonProperty(value="errors")
        @Generated
        public B errors(Collection<? extends PassportElementError> errors) {
            if (errors == null) {
                throw new NullPointerException("errors cannot be null");
            }
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.addAll(errors);
            return (B)this.self();
        }

        @Generated
        public B clearErrors() {
            if (this.errors != null) {
                this.errors.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetPassportDataErrors.SetPassportDataErrorsBuilder(super=" + super.toString() + ", userId=" + this.userId + ", errors=" + this.errors + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SetPassportDataErrorsBuilderImpl
    extends SetPassportDataErrorsBuilder<SetPassportDataErrors, SetPassportDataErrorsBuilderImpl> {
        @Generated
        private SetPassportDataErrorsBuilderImpl() {
        }

        @Override
        @Generated
        protected SetPassportDataErrorsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SetPassportDataErrors build() {
            return new SetPassportDataErrors(this);
        }
    }
}

