/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.games;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.games.GameHighScore;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=GetGameHighScoresBuilderImpl.class)
public class GetGameHighScores
extends BotApiMethod<ArrayList<GameHighScore>> {
    public static final String PATH = "getGameHighScores";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String USER_ID_FIELD = "user_id";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;

    public void setChatId(Long chatId) {
        this.chatId = chatId == null ? null : chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ArrayList<GameHighScore> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, GameHighScore.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null || this.chatId.isEmpty()) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
    }

    @Generated
    protected GetGameHighScores(GetGameHighScoresBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        this.messageId = b.messageId;
        this.inlineMessageId = b.inlineMessageId;
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
    }

    @Generated
    public static GetGameHighScoresBuilder<?, ?> builder() {
        return new GetGameHighScoresBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetGameHighScores)) {
            return false;
        }
        GetGameHighScores other = (GetGameHighScores)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        return !(this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GetGameHighScores;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        return result;
    }

    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    @Generated
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    public String toString() {
        return "GetGameHighScores(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", userId=" + this.getUserId() + ")";
    }

    @Generated
    public GetGameHighScores(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    public GetGameHighScores(String chatId, Integer messageId, String inlineMessageId, @NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.userId = userId;
    }

    public static abstract class GetGameHighScoresBuilder<C extends GetGameHighScores, B extends GetGameHighScoresBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<ArrayList<GameHighScore>, C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageId;
        @Generated
        private String inlineMessageId;
        @Generated
        private Long userId;

        public GetGameHighScoresBuilder<C, B> chatId(Long chatId) {
            this.chatId = chatId == null ? null : chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(String chatId) {
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(Integer messageId) {
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="inline_message_id")
        @Generated
        public B inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="user_id")
        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GetGameHighScores.GetGameHighScoresBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", userId=" + this.userId + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class GetGameHighScoresBuilderImpl
    extends GetGameHighScoresBuilder<GetGameHighScores, GetGameHighScoresBuilderImpl> {
        @Generated
        private GetGameHighScoresBuilderImpl() {
        }

        @Override
        @Generated
        protected GetGameHighScoresBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GetGameHighScores build() {
            return new GetGameHighScores(this);
        }
    }
}

