/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.ChatPermissions;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=RestrictChatMemberBuilderImpl.class)
public class RestrictChatMember
extends BotApiMethodBoolean {
    public static final String PATH = "restrictchatmember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    private static final String UNTILDATE_FIELD = "until_date";
    private static final String CANSENDMESSAGES_FIELD = "can_send_messages";
    private static final String CANSENDMEDIAMESSAGES_FIELD = "can_send_media_messages";
    private static final String CANSENDOTHERMESSAGES_FIELD = "can_send_other_messages";
    private static final String CANADDWEBPAGEPREVIEWS_FIELD = "can_add_web_page_previews";
    private static final String PERMISSIONS_FIELD = "permissions";
    private static final String USEINDEPENDENTCHATPERMISSIONS_FIELD = "use_independent_chat_permissions";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="permissions")
    @NonNull
    private ChatPermissions permissions;
    @JsonProperty(value="until_date")
    private Integer untilDate;
    @JsonProperty(value="use_independent_chat_permissions")
    private Boolean useIndependentChatPermissions;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @JsonIgnore
    public void setUntilDateInstant(Instant instant) {
        this.setUntilDate((int)instant.getEpochSecond());
    }

    @JsonIgnore
    public void setUntilDateDateTime(ZonedDateTime date) {
        this.setUntilDateInstant(date.toInstant());
    }

    @JsonIgnore
    public void forTimePeriodDuration(Duration duration) {
        this.setUntilDateInstant(Instant.now().plusMillis(duration.toMillis()));
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
    }

    @Generated
    protected RestrictChatMember(RestrictChatMemberBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.permissions = b.permissions;
        if (this.permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.untilDate = b.untilDate;
        this.useIndependentChatPermissions = b.useIndependentChatPermissions;
    }

    @Generated
    public static RestrictChatMemberBuilder<?, ?> builder() {
        return new RestrictChatMemberBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestrictChatMember)) {
            return false;
        }
        RestrictChatMember other = (RestrictChatMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$untilDate = this.getUntilDate();
        Integer other$untilDate = other.getUntilDate();
        if (this$untilDate == null ? other$untilDate != null : !((Object)this$untilDate).equals(other$untilDate)) {
            return false;
        }
        Boolean this$useIndependentChatPermissions = this.getUseIndependentChatPermissions();
        Boolean other$useIndependentChatPermissions = other.getUseIndependentChatPermissions();
        if (this$useIndependentChatPermissions == null ? other$useIndependentChatPermissions != null : !((Object)this$useIndependentChatPermissions).equals(other$useIndependentChatPermissions)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        ChatPermissions this$permissions = this.getPermissions();
        ChatPermissions other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestrictChatMember;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : ((Object)$untilDate).hashCode());
        Boolean $useIndependentChatPermissions = this.getUseIndependentChatPermissions();
        result = result * 59 + ($useIndependentChatPermissions == null ? 43 : ((Object)$useIndependentChatPermissions).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        ChatPermissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    @Generated
    public ChatPermissions getPermissions() {
        return this.permissions;
    }

    @Generated
    public Integer getUntilDate() {
        return this.untilDate;
    }

    @Generated
    public Boolean getUseIndependentChatPermissions() {
        return this.useIndependentChatPermissions;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="permissions")
    @Generated
    public void setPermissions(@NonNull ChatPermissions permissions) {
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.permissions = permissions;
    }

    @JsonProperty(value="until_date")
    @Generated
    public void setUntilDate(Integer untilDate) {
        this.untilDate = untilDate;
    }

    @JsonProperty(value="use_independent_chat_permissions")
    @Generated
    public void setUseIndependentChatPermissions(Boolean useIndependentChatPermissions) {
        this.useIndependentChatPermissions = useIndependentChatPermissions;
    }

    @Generated
    public String toString() {
        return "RestrictChatMember(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ", permissions=" + this.getPermissions() + ", untilDate=" + this.getUntilDate() + ", useIndependentChatPermissions=" + this.getUseIndependentChatPermissions() + ")";
    }

    @Generated
    public RestrictChatMember(@NonNull String chatId, @NonNull Long userId, @NonNull ChatPermissions permissions) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.permissions = permissions;
    }

    @Generated
    public RestrictChatMember(@NonNull String chatId, @NonNull Long userId, @NonNull ChatPermissions permissions, Integer untilDate, Boolean useIndependentChatPermissions) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.permissions = permissions;
        this.untilDate = untilDate;
        this.useIndependentChatPermissions = useIndependentChatPermissions;
    }

    public static abstract class RestrictChatMemberBuilder<C extends RestrictChatMember, B extends RestrictChatMemberBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Long userId;
        @Generated
        private ChatPermissions permissions;
        @Generated
        private Integer untilDate;
        @Generated
        private Boolean useIndependentChatPermissions;

        public RestrictChatMemberBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="user_id")
        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @JsonProperty(value="permissions")
        @Generated
        public B permissions(@NonNull ChatPermissions permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions is marked non-null but is null");
            }
            this.permissions = permissions;
            return (B)this.self();
        }

        @JsonProperty(value="until_date")
        @Generated
        public B untilDate(Integer untilDate) {
            this.untilDate = untilDate;
            return (B)this.self();
        }

        @JsonProperty(value="use_independent_chat_permissions")
        @Generated
        public B useIndependentChatPermissions(Boolean useIndependentChatPermissions) {
            this.useIndependentChatPermissions = useIndependentChatPermissions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RestrictChatMember.RestrictChatMemberBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", userId=" + this.userId + ", permissions=" + this.permissions + ", untilDate=" + this.untilDate + ", useIndependentChatPermissions=" + this.useIndependentChatPermissions + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class RestrictChatMemberBuilderImpl
    extends RestrictChatMemberBuilder<RestrictChatMember, RestrictChatMemberBuilderImpl> {
        @Generated
        private RestrictChatMemberBuilderImpl() {
        }

        @Override
        @Generated
        protected RestrictChatMemberBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RestrictChatMember build() {
            return new RestrictChatMember(this);
        }
    }
}

