/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodSerializable;
import org.telegram.telegrambots.meta.api.objects.LinkPreviewOptions;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=EditMessageTextBuilderImpl.class)
public class EditMessageText
extends BotApiMethodSerializable {
    public static final String PATH = "editmessagetext";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String TEXT_FIELD = "text";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String DISABLE_WEB_PREVIEW_FIELD = "disable_web_page_preview";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String ENTITIES_FIELD = "entities";
    private static final String LINK_PREVIEW_OPTIONS_FIELD = "link_preview_options";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;
    @JsonProperty(value="link_preview_options")
    private LinkPreviewOptions linkPreviewOptions;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;

    public void disableWebPagePreview() {
        this.disableWebPagePreview = true;
    }

    public void enableWebPagePreview() {
        this.disableWebPagePreview = null;
    }

    public void enableMarkdown(boolean enable) {
        this.parseMode = enable ? "Markdown" : null;
    }

    public void enableHtml(boolean enable) {
        this.parseMode = enable ? "html" : null;
    }

    public void setChatId(Long chatId) {
        this.chatId = chatId == null ? null : chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Serializable deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponseMessageOrBoolean(answer);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null || this.chatId.isEmpty()) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
        if (this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.parseMode != null && this.entities != null && !this.entities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.linkPreviewOptions != null) {
            this.linkPreviewOptions.validate();
        }
    }

    @Generated
    protected EditMessageText(EditMessageTextBuilder<?, ?> b) {
        super((BotApiMethodSerializable.BotApiMethodSerializableBuilder<?, ?>)b);
        this.chatId = b.chatId;
        this.messageId = b.messageId;
        this.inlineMessageId = b.inlineMessageId;
        this.text = b.text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.parseMode = b.parseMode;
        this.disableWebPagePreview = b.disableWebPagePreview;
        this.replyMarkup = b.replyMarkup;
        this.entities = b.entities;
        this.linkPreviewOptions = b.linkPreviewOptions;
        this.businessConnectionId = b.businessConnectionId;
    }

    @Generated
    public static EditMessageTextBuilder<?, ?> builder() {
        return new EditMessageTextBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditMessageText)) {
            return false;
        }
        EditMessageText other = (EditMessageText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$disableWebPagePreview = this.getDisableWebPagePreview();
        Boolean other$disableWebPagePreview = other.getDisableWebPagePreview();
        if (this$disableWebPagePreview == null ? other$disableWebPagePreview != null : !((Object)this$disableWebPagePreview).equals(other$disableWebPagePreview)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        if (this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        List<MessageEntity> this$entities = this.getEntities();
        List<MessageEntity> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        LinkPreviewOptions this$linkPreviewOptions = this.getLinkPreviewOptions();
        LinkPreviewOptions other$linkPreviewOptions = other.getLinkPreviewOptions();
        if (this$linkPreviewOptions == null ? other$linkPreviewOptions != null : !((Object)this$linkPreviewOptions).equals(other$linkPreviewOptions)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        return !(this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditMessageText;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $disableWebPagePreview = this.getDisableWebPagePreview();
        result = result * 59 + ($disableWebPagePreview == null ? 43 : ((Object)$disableWebPagePreview).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        List<MessageEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        LinkPreviewOptions $linkPreviewOptions = this.getLinkPreviewOptions();
        result = result * 59 + ($linkPreviewOptions == null ? 43 : ((Object)$linkPreviewOptions).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        return result;
    }

    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public List<MessageEntity> getEntities() {
        return this.entities;
    }

    @Generated
    public LinkPreviewOptions getLinkPreviewOptions() {
        return this.linkPreviewOptions;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    @Generated
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="disable_web_page_preview")
    @Generated
    public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
        this.disableWebPagePreview = disableWebPagePreview;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="entities")
    @Generated
    public void setEntities(List<MessageEntity> entities) {
        this.entities = entities;
    }

    @JsonProperty(value="link_preview_options")
    @Generated
    public void setLinkPreviewOptions(LinkPreviewOptions linkPreviewOptions) {
        this.linkPreviewOptions = linkPreviewOptions;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @Generated
    public String toString() {
        return "EditMessageText(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", text=" + this.getText() + ", parseMode=" + this.getParseMode() + ", disableWebPagePreview=" + this.getDisableWebPagePreview() + ", replyMarkup=" + this.getReplyMarkup() + ", entities=" + this.getEntities() + ", linkPreviewOptions=" + this.getLinkPreviewOptions() + ", businessConnectionId=" + this.getBusinessConnectionId() + ")";
    }

    @Generated
    public EditMessageText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @Generated
    public EditMessageText(String chatId, Integer messageId, String inlineMessageId, @NonNull String text, String parseMode, Boolean disableWebPagePreview, InlineKeyboardMarkup replyMarkup, List<MessageEntity> entities, LinkPreviewOptions linkPreviewOptions, String businessConnectionId) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.text = text;
        this.parseMode = parseMode;
        this.disableWebPagePreview = disableWebPagePreview;
        this.replyMarkup = replyMarkup;
        this.entities = entities;
        this.linkPreviewOptions = linkPreviewOptions;
        this.businessConnectionId = businessConnectionId;
    }

    public static abstract class EditMessageTextBuilder<C extends EditMessageText, B extends EditMessageTextBuilder<C, B>>
    extends BotApiMethodSerializable.BotApiMethodSerializableBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageId;
        @Generated
        private String inlineMessageId;
        @Generated
        private String text;
        @Generated
        private String parseMode;
        @Generated
        private Boolean disableWebPagePreview;
        @Generated
        private InlineKeyboardMarkup replyMarkup;
        @Generated
        private List<MessageEntity> entities;
        @Generated
        private LinkPreviewOptions linkPreviewOptions;
        @Generated
        private String businessConnectionId;

        public EditMessageTextBuilder<C, B> chatId(Long chatId) {
            this.chatId = chatId == null ? null : chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(String chatId) {
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(Integer messageId) {
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="inline_message_id")
        @Generated
        public B inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="text")
        @Generated
        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return (B)this.self();
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return (B)this.self();
        }

        @JsonProperty(value="disable_web_page_preview")
        @Generated
        public B disableWebPagePreview(Boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="entities")
        @Generated
        public B entities(List<MessageEntity> entities) {
            this.entities = entities;
            return (B)this.self();
        }

        @JsonProperty(value="link_preview_options")
        @Generated
        public B linkPreviewOptions(LinkPreviewOptions linkPreviewOptions) {
            this.linkPreviewOptions = linkPreviewOptions;
            return (B)this.self();
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EditMessageText.EditMessageTextBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", text=" + this.text + ", parseMode=" + this.parseMode + ", disableWebPagePreview=" + this.disableWebPagePreview + ", replyMarkup=" + this.replyMarkup + ", entities=" + this.entities + ", linkPreviewOptions=" + this.linkPreviewOptions + ", businessConnectionId=" + this.businessConnectionId + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class EditMessageTextBuilderImpl
    extends EditMessageTextBuilder<EditMessageText, EditMessageTextBuilderImpl> {
        @Generated
        private EditMessageTextBuilderImpl() {
        }

        @Override
        @Generated
        protected EditMessageTextBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EditMessageText build() {
            return new EditMessageText(this);
        }
    }
}

