/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=ForwardMessageBuilderImpl.class)
public class ForwardMessage
extends BotApiMethodMessage {
    public static final String PATH = "forwardmessage";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGETHREADID_FIELD = "message_thread_id";
    private static final String FROMCHATID_FIELD = "from_chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String PROTECTCONTENT_FIELD = "protect_content";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="from_chat_id")
    @NonNull
    private String fromChatId;
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void setFromChatId(@NonNull Long fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId.toString();
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (this.fromChatId.isEmpty()) {
            throw new TelegramApiValidationException("FromChatId can't be empty", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Generated
    protected ForwardMessage(ForwardMessageBuilder<?, ?> b) {
        super((BotApiMethodMessage.BotApiMethodMessageBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.fromChatId = b.fromChatId;
        if (this.fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.messageId = b.messageId;
        if (this.messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.disableNotification = b.disableNotification;
        this.protectContent = b.protectContent;
    }

    @Generated
    public static ForwardMessageBuilder<?, ?> builder() {
        return new ForwardMessageBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForwardMessage)) {
            return false;
        }
        ForwardMessage other = (ForwardMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$fromChatId = this.getFromChatId();
        String other$fromChatId = other.getFromChatId();
        return !(this$fromChatId == null ? other$fromChatId != null : !this$fromChatId.equals(other$fromChatId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ForwardMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $fromChatId = this.getFromChatId();
        result = result * 59 + ($fromChatId == null ? 43 : $fromChatId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    @Generated
    public String getFromChatId() {
        return this.fromChatId;
    }

    @NonNull
    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="from_chat_id")
    @Generated
    public void setFromChatId(@NonNull String fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="disable_notification")
    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="protect_content")
    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @Generated
    public String toString() {
        return "ForwardMessage(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", fromChatId=" + this.getFromChatId() + ", messageId=" + this.getMessageId() + ", disableNotification=" + this.getDisableNotification() + ", protectContent=" + this.getProtectContent() + ")";
    }

    @Generated
    public ForwardMessage(@NonNull String chatId, @NonNull String fromChatId, @NonNull Integer messageId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.fromChatId = fromChatId;
        this.messageId = messageId;
    }

    @Generated
    public ForwardMessage(@NonNull String chatId, Integer messageThreadId, @NonNull String fromChatId, @NonNull Integer messageId, Boolean disableNotification, Boolean protectContent) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.fromChatId = fromChatId;
        this.messageId = messageId;
        this.disableNotification = disableNotification;
        this.protectContent = protectContent;
    }

    public static abstract class ForwardMessageBuilder<C extends ForwardMessage, B extends ForwardMessageBuilder<C, B>>
    extends BotApiMethodMessage.BotApiMethodMessageBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private String fromChatId;
        @Generated
        private Integer messageId;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Boolean protectContent;

        public ForwardMessageBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public ForwardMessageBuilder<C, B> fromChatId(@NonNull Long fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="from_chat_id")
        @Generated
        public B fromChatId(@NonNull String fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ForwardMessage.ForwardMessageBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", fromChatId=" + this.fromChatId + ", messageId=" + this.messageId + ", disableNotification=" + this.disableNotification + ", protectContent=" + this.protectContent + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ForwardMessageBuilderImpl
    extends ForwardMessageBuilder<ForwardMessage, ForwardMessageBuilderImpl> {
        @Generated
        private ForwardMessageBuilderImpl() {
        }

        @Override
        @Generated
        protected ForwardMessageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ForwardMessage build() {
            return new ForwardMessage(this);
        }
    }
}

