/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SetChatPhotoBuilderImpl.class)
public class SetChatPhoto
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "setChatPhoto";
    public static final String CHATID_FIELD = "chat_id";
    public static final String PHOTO_FIELD = "photo";
    @NonNull
    private String chatId;
    @NonNull
    private InputFile photo;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (!this.photo.isNew()) {
            throw new TelegramApiValidationException("Photo parameter is required and must be a new file to upload", this);
        }
    }

    @Generated
    protected SetChatPhoto(SetChatPhotoBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.photo = b.photo;
        if (this.photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
    }

    @Generated
    public static SetChatPhotoBuilder<?, ?> builder() {
        return new SetChatPhotoBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetChatPhoto)) {
            return false;
        }
        SetChatPhoto other = (SetChatPhoto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputFile this$photo = this.getPhoto();
        InputFile other$photo = other.getPhoto();
        return !(this$photo == null ? other$photo != null : !((Object)this$photo).equals(other$photo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetChatPhoto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputFile $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : ((Object)$photo).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public InputFile getPhoto() {
        return this.photo;
    }

    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @Generated
    public void setPhoto(@NonNull InputFile photo) {
        if (photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
        this.photo = photo;
    }

    @Generated
    public String toString() {
        return "SetChatPhoto(chatId=" + this.getChatId() + ", photo=" + this.getPhoto() + ")";
    }

    @Generated
    public SetChatPhoto(@NonNull String chatId, @NonNull InputFile photo) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (photo == null) {
            throw new NullPointerException("photo is marked non-null but is null");
        }
        this.chatId = chatId;
        this.photo = photo;
    }

    public static abstract class SetChatPhotoBuilder<C extends SetChatPhoto, B extends SetChatPhotoBuilder<C, B>>
    extends PartialBotApiMethod.PartialBotApiMethodBuilder<Boolean, C, B> {
        @Generated
        private String chatId;
        @Generated
        private InputFile photo;

        public SetChatPhotoBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @Generated
        public B photo(@NonNull InputFile photo) {
            if (photo == null) {
                throw new NullPointerException("photo is marked non-null but is null");
            }
            this.photo = photo;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetChatPhoto.SetChatPhotoBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", photo=" + this.photo + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SetChatPhotoBuilderImpl
    extends SetChatPhotoBuilder<SetChatPhoto, SetChatPhotoBuilderImpl> {
        @Generated
        private SetChatPhotoBuilderImpl() {
        }

        @Override
        @Generated
        protected SetChatPhotoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SetChatPhoto build() {
            return new SetChatPhoto(this);
        }
    }
}

