/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.reactions;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.reactions.ReactionType;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SetMessageReactionBuilderImpl.class)
public class SetMessageReaction
extends BotApiMethodBoolean {
    public static final String PATH = "setMessageReaction";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String REACTION_FIELD = "reaction";
    private static final String IS_BIG_FIELD = "is_big";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;
    @JsonProperty(value="reaction")
    private List<ReactionType> reactionTypes;
    @JsonProperty(value="is_big")
    private Boolean isBig;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (this.reactionTypes != null) {
            for (ReactionType reactionType : this.reactionTypes) {
                if ("paid".equals(reactionType.getType())) {
                    throw new TelegramApiValidationException("ReactionType can't be paid", this);
                }
                reactionType.validate();
            }
        }
    }

    @Generated
    protected SetMessageReaction(SetMessageReactionBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageId = b.messageId;
        if (this.messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.reactionTypes = b.reactionTypes;
        this.isBig = b.isBig;
    }

    @Generated
    public static SetMessageReactionBuilder<?, ?> builder() {
        return new SetMessageReactionBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetMessageReaction)) {
            return false;
        }
        SetMessageReaction other = (SetMessageReaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$isBig = this.getIsBig();
        Boolean other$isBig = other.getIsBig();
        if (this$isBig == null ? other$isBig != null : !((Object)this$isBig).equals(other$isBig)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        List<ReactionType> this$reactionTypes = this.getReactionTypes();
        List<ReactionType> other$reactionTypes = other.getReactionTypes();
        return !(this$reactionTypes == null ? other$reactionTypes != null : !((Object)this$reactionTypes).equals(other$reactionTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetMessageReaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $isBig = this.getIsBig();
        result = result * 59 + ($isBig == null ? 43 : ((Object)$isBig).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        List<ReactionType> $reactionTypes = this.getReactionTypes();
        result = result * 59 + ($reactionTypes == null ? 43 : ((Object)$reactionTypes).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public List<ReactionType> getReactionTypes() {
        return this.reactionTypes;
    }

    @Generated
    public Boolean getIsBig() {
        return this.isBig;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="reaction")
    @Generated
    public void setReactionTypes(List<ReactionType> reactionTypes) {
        this.reactionTypes = reactionTypes;
    }

    @JsonProperty(value="is_big")
    @Generated
    public void setIsBig(Boolean isBig) {
        this.isBig = isBig;
    }

    @Generated
    public String toString() {
        return "SetMessageReaction(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", reactionTypes=" + this.getReactionTypes() + ", isBig=" + this.getIsBig() + ")";
    }

    @Generated
    public SetMessageReaction(@NonNull String chatId, @NonNull Integer messageId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
    }

    @Generated
    public SetMessageReaction(@NonNull String chatId, @NonNull Integer messageId, List<ReactionType> reactionTypes, Boolean isBig) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.reactionTypes = reactionTypes;
        this.isBig = isBig;
    }

    public static abstract class SetMessageReactionBuilder<C extends SetMessageReaction, B extends SetMessageReactionBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageId;
        @Generated
        private List<ReactionType> reactionTypes;
        @Generated
        private Boolean isBig;

        public SetMessageReactionBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="reaction")
        @Generated
        public B reactionTypes(List<ReactionType> reactionTypes) {
            this.reactionTypes = reactionTypes;
            return (B)this.self();
        }

        @JsonProperty(value="is_big")
        @Generated
        public B isBig(Boolean isBig) {
            this.isBig = isBig;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetMessageReaction.SetMessageReactionBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", reactionTypes=" + this.reactionTypes + ", isBig=" + this.isBig + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SetMessageReactionBuilderImpl
    extends SetMessageReactionBuilder<SetMessageReaction, SetMessageReactionBuilderImpl> {
        @Generated
        private SetMessageReactionBuilderImpl() {
        }

        @Override
        @Generated
        protected SetMessageReactionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SetMessageReaction build() {
            return new SetMessageReaction(this);
        }
    }
}

