/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.chat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=ChatBuilderImpl.class)
public class Chat
implements BotApiObject {
    private static final String ID_FIELD = "id";
    private static final String TYPE_FIELD = "type";
    private static final String TITLE_FIELD = "title";
    private static final String USERNAME_FIELD = "username";
    private static final String FIRST_NAME_FIELD = "first_name";
    private static final String LAST_NAME_FIELD = "last_name";
    private static final String IS_FORUM_FIELD = "is_forum";
    private static final String USER_CHAT_TYPE = "private";
    private static final String GROUP_CHAT_TYPE = "group";
    private static final String CHANNEL_CHAT_TYPE = "channel";
    private static final String SUPERGROUP_CHAT_TYPE = "supergroup";
    @JsonProperty(value="id")
    @NonNull
    private Long id;
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="username")
    private String userName;
    @JsonProperty(value="is_forum")
    private Boolean isForum;

    @JsonIgnore
    public Boolean isGroupChat() {
        return GROUP_CHAT_TYPE.equals(this.type);
    }

    @JsonIgnore
    public Boolean isChannelChat() {
        return CHANNEL_CHAT_TYPE.equals(this.type);
    }

    @JsonIgnore
    public Boolean isUserChat() {
        return USER_CHAT_TYPE.equals(this.type);
    }

    @JsonIgnore
    public Boolean isSuperGroupChat() {
        return SUPERGROUP_CHAT_TYPE.equals(this.type);
    }

    @Generated
    protected Chat(ChatBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.type = b.type;
        if (this.type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.title = b.title;
        this.firstName = b.firstName;
        this.lastName = b.lastName;
        this.userName = b.userName;
        this.isForum = b.isForum;
    }

    @Generated
    public static ChatBuilder<?, ?> builder() {
        return new ChatBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chat)) {
            return false;
        }
        Chat other = (Chat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$isForum = this.getIsForum();
        Boolean other$isForum = other.getIsForum();
        if (this$isForum == null ? other$isForum != null : !((Object)this$isForum).equals(other$isForum)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Chat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $isForum = this.getIsForum();
        result = result * 59 + ($isForum == null ? 43 : ((Object)$isForum).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public Boolean getIsForum() {
        return this.isForum;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="type")
    @Generated
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="title")
    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="first_name")
    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @JsonProperty(value="last_name")
    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty(value="username")
    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty(value="is_forum")
    @Generated
    public void setIsForum(Boolean isForum) {
        this.isForum = isForum;
    }

    @Generated
    public String toString() {
        return "Chat(id=" + this.getId() + ", type=" + this.getType() + ", title=" + this.getTitle() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", userName=" + this.getUserName() + ", isForum=" + this.getIsForum() + ")";
    }

    @Generated
    public Chat(@NonNull Long id, @NonNull String type) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.id = id;
        this.type = type;
    }

    @Generated
    public Chat(@NonNull Long id, @NonNull String type, String title, String firstName, String lastName, String userName, Boolean isForum) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.id = id;
        this.type = type;
        this.title = title;
        this.firstName = firstName;
        this.lastName = lastName;
        this.userName = userName;
        this.isForum = isForum;
    }

    @Generated
    protected Chat() {
    }

    @Generated
    public static abstract class ChatBuilder<C extends Chat, B extends ChatBuilder<C, B>> {
        @Generated
        private Long id;
        @Generated
        private String type;
        @Generated
        private String title;
        @Generated
        private String firstName;
        @Generated
        private String lastName;
        @Generated
        private String userName;
        @Generated
        private Boolean isForum;

        @JsonProperty(value="id")
        @Generated
        public B id(@NonNull Long id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="type")
        @Generated
        public B type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this.self();
        }

        @JsonProperty(value="title")
        @Generated
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="first_name")
        @Generated
        public B firstName(String firstName) {
            this.firstName = firstName;
            return this.self();
        }

        @JsonProperty(value="last_name")
        @Generated
        public B lastName(String lastName) {
            this.lastName = lastName;
            return this.self();
        }

        @JsonProperty(value="username")
        @Generated
        public B userName(String userName) {
            this.userName = userName;
            return this.self();
        }

        @JsonProperty(value="is_forum")
        @Generated
        public B isForum(Boolean isForum) {
            this.isForum = isForum;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Chat.ChatBuilder(id=" + this.id + ", type=" + this.type + ", title=" + this.title + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", userName=" + this.userName + ", isForum=" + this.isForum + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ChatBuilderImpl
    extends ChatBuilder<Chat, ChatBuilderImpl> {
        @Generated
        private ChatBuilderImpl() {
        }

        @Override
        @Generated
        protected ChatBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Chat build() {
            return new Chat(this);
        }
    }
}

