/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.stories;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class StoryAreaPosition
implements BotApiObject,
Validable {
    private static final String X_PERCENTAGE_FIELD = "x_percentage";
    private static final String Y_PERCENTAGE_FIELD = "y_percentage";
    private static final String WIDTH_PERCENTAGE_FIELD = "width_percentage";
    private static final String HEIGHT_PERCENTAGE_FIELD = "height_percentage";
    private static final String ROTATION_ANGLE_FIELD = "rotation_angle";
    private static final String CORNER_RADIUS_PERCENTAGE_FIELD = "corner_radius_percentage";
    @JsonProperty(value="x_percentage")
    @NonNull
    private Float xPercentage;
    @JsonProperty(value="y_percentage")
    @NonNull
    private Float yPercentage;
    @JsonProperty(value="width_percentage")
    @NonNull
    private Float widthPercentage;
    @JsonProperty(value="height_percentage")
    @NonNull
    private Float heightPercentage;
    @JsonProperty(value="rotation_angle")
    @NonNull
    private Float rotationAngle;
    @JsonProperty(value="corner_radius_percentage")
    @NonNull
    private Float cornerRadiusPercentage;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.rotationAngle.floatValue() < 0.0f || this.rotationAngle.floatValue() > 360.0f) {
            throw new TelegramApiValidationException("RotationAngle must be between 0 and 360 degrees", this);
        }
    }

    @Generated
    public static StoryAreaPositionBuilder builder() {
        return new StoryAreaPositionBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoryAreaPosition)) {
            return false;
        }
        StoryAreaPosition other = (StoryAreaPosition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$xPercentage = this.getXPercentage();
        Float other$xPercentage = other.getXPercentage();
        if (this$xPercentage == null ? other$xPercentage != null : !((Object)this$xPercentage).equals(other$xPercentage)) {
            return false;
        }
        Float this$yPercentage = this.getYPercentage();
        Float other$yPercentage = other.getYPercentage();
        if (this$yPercentage == null ? other$yPercentage != null : !((Object)this$yPercentage).equals(other$yPercentage)) {
            return false;
        }
        Float this$widthPercentage = this.getWidthPercentage();
        Float other$widthPercentage = other.getWidthPercentage();
        if (this$widthPercentage == null ? other$widthPercentage != null : !((Object)this$widthPercentage).equals(other$widthPercentage)) {
            return false;
        }
        Float this$heightPercentage = this.getHeightPercentage();
        Float other$heightPercentage = other.getHeightPercentage();
        if (this$heightPercentage == null ? other$heightPercentage != null : !((Object)this$heightPercentage).equals(other$heightPercentage)) {
            return false;
        }
        Float this$rotationAngle = this.getRotationAngle();
        Float other$rotationAngle = other.getRotationAngle();
        if (this$rotationAngle == null ? other$rotationAngle != null : !((Object)this$rotationAngle).equals(other$rotationAngle)) {
            return false;
        }
        Float this$cornerRadiusPercentage = this.getCornerRadiusPercentage();
        Float other$cornerRadiusPercentage = other.getCornerRadiusPercentage();
        return !(this$cornerRadiusPercentage == null ? other$cornerRadiusPercentage != null : !((Object)this$cornerRadiusPercentage).equals(other$cornerRadiusPercentage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StoryAreaPosition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $xPercentage = this.getXPercentage();
        result = result * 59 + ($xPercentage == null ? 43 : ((Object)$xPercentage).hashCode());
        Float $yPercentage = this.getYPercentage();
        result = result * 59 + ($yPercentage == null ? 43 : ((Object)$yPercentage).hashCode());
        Float $widthPercentage = this.getWidthPercentage();
        result = result * 59 + ($widthPercentage == null ? 43 : ((Object)$widthPercentage).hashCode());
        Float $heightPercentage = this.getHeightPercentage();
        result = result * 59 + ($heightPercentage == null ? 43 : ((Object)$heightPercentage).hashCode());
        Float $rotationAngle = this.getRotationAngle();
        result = result * 59 + ($rotationAngle == null ? 43 : ((Object)$rotationAngle).hashCode());
        Float $cornerRadiusPercentage = this.getCornerRadiusPercentage();
        result = result * 59 + ($cornerRadiusPercentage == null ? 43 : ((Object)$cornerRadiusPercentage).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Float getXPercentage() {
        return this.xPercentage;
    }

    @NonNull
    @Generated
    public Float getYPercentage() {
        return this.yPercentage;
    }

    @NonNull
    @Generated
    public Float getWidthPercentage() {
        return this.widthPercentage;
    }

    @NonNull
    @Generated
    public Float getHeightPercentage() {
        return this.heightPercentage;
    }

    @NonNull
    @Generated
    public Float getRotationAngle() {
        return this.rotationAngle;
    }

    @NonNull
    @Generated
    public Float getCornerRadiusPercentage() {
        return this.cornerRadiusPercentage;
    }

    @JsonProperty(value="x_percentage")
    @Generated
    public void setXPercentage(@NonNull Float xPercentage) {
        if (xPercentage == null) {
            throw new NullPointerException("xPercentage is marked non-null but is null");
        }
        this.xPercentage = xPercentage;
    }

    @JsonProperty(value="y_percentage")
    @Generated
    public void setYPercentage(@NonNull Float yPercentage) {
        if (yPercentage == null) {
            throw new NullPointerException("yPercentage is marked non-null but is null");
        }
        this.yPercentage = yPercentage;
    }

    @JsonProperty(value="width_percentage")
    @Generated
    public void setWidthPercentage(@NonNull Float widthPercentage) {
        if (widthPercentage == null) {
            throw new NullPointerException("widthPercentage is marked non-null but is null");
        }
        this.widthPercentage = widthPercentage;
    }

    @JsonProperty(value="height_percentage")
    @Generated
    public void setHeightPercentage(@NonNull Float heightPercentage) {
        if (heightPercentage == null) {
            throw new NullPointerException("heightPercentage is marked non-null but is null");
        }
        this.heightPercentage = heightPercentage;
    }

    @JsonProperty(value="rotation_angle")
    @Generated
    public void setRotationAngle(@NonNull Float rotationAngle) {
        if (rotationAngle == null) {
            throw new NullPointerException("rotationAngle is marked non-null but is null");
        }
        this.rotationAngle = rotationAngle;
    }

    @JsonProperty(value="corner_radius_percentage")
    @Generated
    public void setCornerRadiusPercentage(@NonNull Float cornerRadiusPercentage) {
        if (cornerRadiusPercentage == null) {
            throw new NullPointerException("cornerRadiusPercentage is marked non-null but is null");
        }
        this.cornerRadiusPercentage = cornerRadiusPercentage;
    }

    @Generated
    public String toString() {
        return "StoryAreaPosition(xPercentage=" + this.getXPercentage() + ", yPercentage=" + this.getYPercentage() + ", widthPercentage=" + this.getWidthPercentage() + ", heightPercentage=" + this.getHeightPercentage() + ", rotationAngle=" + this.getRotationAngle() + ", cornerRadiusPercentage=" + this.getCornerRadiusPercentage() + ")";
    }

    @Generated
    public StoryAreaPosition() {
    }

    @Generated
    public StoryAreaPosition(@NonNull Float xPercentage, @NonNull Float yPercentage, @NonNull Float widthPercentage, @NonNull Float heightPercentage, @NonNull Float rotationAngle, @NonNull Float cornerRadiusPercentage) {
        if (xPercentage == null) {
            throw new NullPointerException("xPercentage is marked non-null but is null");
        }
        if (yPercentage == null) {
            throw new NullPointerException("yPercentage is marked non-null but is null");
        }
        if (widthPercentage == null) {
            throw new NullPointerException("widthPercentage is marked non-null but is null");
        }
        if (heightPercentage == null) {
            throw new NullPointerException("heightPercentage is marked non-null but is null");
        }
        if (rotationAngle == null) {
            throw new NullPointerException("rotationAngle is marked non-null but is null");
        }
        if (cornerRadiusPercentage == null) {
            throw new NullPointerException("cornerRadiusPercentage is marked non-null but is null");
        }
        this.xPercentage = xPercentage;
        this.yPercentage = yPercentage;
        this.widthPercentage = widthPercentage;
        this.heightPercentage = heightPercentage;
        this.rotationAngle = rotationAngle;
        this.cornerRadiusPercentage = cornerRadiusPercentage;
    }

    @Generated
    public static class StoryAreaPositionBuilder {
        @Generated
        private Float xPercentage;
        @Generated
        private Float yPercentage;
        @Generated
        private Float widthPercentage;
        @Generated
        private Float heightPercentage;
        @Generated
        private Float rotationAngle;
        @Generated
        private Float cornerRadiusPercentage;

        @Generated
        StoryAreaPositionBuilder() {
        }

        @JsonProperty(value="x_percentage")
        @Generated
        public StoryAreaPositionBuilder xPercentage(@NonNull Float xPercentage) {
            if (xPercentage == null) {
                throw new NullPointerException("xPercentage is marked non-null but is null");
            }
            this.xPercentage = xPercentage;
            return this;
        }

        @JsonProperty(value="y_percentage")
        @Generated
        public StoryAreaPositionBuilder yPercentage(@NonNull Float yPercentage) {
            if (yPercentage == null) {
                throw new NullPointerException("yPercentage is marked non-null but is null");
            }
            this.yPercentage = yPercentage;
            return this;
        }

        @JsonProperty(value="width_percentage")
        @Generated
        public StoryAreaPositionBuilder widthPercentage(@NonNull Float widthPercentage) {
            if (widthPercentage == null) {
                throw new NullPointerException("widthPercentage is marked non-null but is null");
            }
            this.widthPercentage = widthPercentage;
            return this;
        }

        @JsonProperty(value="height_percentage")
        @Generated
        public StoryAreaPositionBuilder heightPercentage(@NonNull Float heightPercentage) {
            if (heightPercentage == null) {
                throw new NullPointerException("heightPercentage is marked non-null but is null");
            }
            this.heightPercentage = heightPercentage;
            return this;
        }

        @JsonProperty(value="rotation_angle")
        @Generated
        public StoryAreaPositionBuilder rotationAngle(@NonNull Float rotationAngle) {
            if (rotationAngle == null) {
                throw new NullPointerException("rotationAngle is marked non-null but is null");
            }
            this.rotationAngle = rotationAngle;
            return this;
        }

        @JsonProperty(value="corner_radius_percentage")
        @Generated
        public StoryAreaPositionBuilder cornerRadiusPercentage(@NonNull Float cornerRadiusPercentage) {
            if (cornerRadiusPercentage == null) {
                throw new NullPointerException("cornerRadiusPercentage is marked non-null but is null");
            }
            this.cornerRadiusPercentage = cornerRadiusPercentage;
            return this;
        }

        @Generated
        public StoryAreaPosition build() {
            return new StoryAreaPosition(this.xPercentage, this.yPercentage, this.widthPercentage, this.heightPercentage, this.rotationAngle, this.cornerRadiusPercentage);
        }

        @Generated
        public String toString() {
            return "StoryAreaPosition.StoryAreaPositionBuilder(xPercentage=" + this.xPercentage + ", yPercentage=" + this.yPercentage + ", widthPercentage=" + this.widthPercentage + ", heightPercentage=" + this.heightPercentage + ", rotationAngle=" + this.rotationAngle + ", cornerRadiusPercentage=" + this.cornerRadiusPercentage + ")";
        }
    }
}

