/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=BanChatMemberBuilderImpl.class)
public class BanChatMember
extends BotApiMethodBoolean {
    public static final String PATH = "banChatMember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    private static final String UNTILDATE_FIELD = "until_date";
    private static final String REVOKEMESSAGES_FIELD = "revoke_messages";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="until_date")
    private Integer untilDate;
    @JsonProperty(value="revoke_messages")
    private Boolean revokeMessages;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @JsonIgnore
    public void setUntilDateInstant(Instant instant) {
        this.setUntilDate((int)instant.getEpochSecond());
    }

    @JsonIgnore
    public void setUntilDateDateTime(ZonedDateTime date) {
        this.setUntilDateInstant(date.toInstant());
    }

    @JsonIgnore
    public void forTimePeriodDuration(Duration duration) {
        this.setUntilDateInstant(Instant.now().plusMillis(duration.toMillis()));
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        Validations.requiredUserId(this.userId, this);
    }

    @Generated
    protected BanChatMember(BanChatMemberBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.untilDate = b.untilDate;
        this.revokeMessages = b.revokeMessages;
    }

    @Generated
    public static BanChatMemberBuilder<?, ?> builder() {
        return new BanChatMemberBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BanChatMember)) {
            return false;
        }
        BanChatMember other = (BanChatMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$untilDate = this.getUntilDate();
        Integer other$untilDate = other.getUntilDate();
        if (this$untilDate == null ? other$untilDate != null : !((Object)this$untilDate).equals(other$untilDate)) {
            return false;
        }
        Boolean this$revokeMessages = this.getRevokeMessages();
        Boolean other$revokeMessages = other.getRevokeMessages();
        if (this$revokeMessages == null ? other$revokeMessages != null : !((Object)this$revokeMessages).equals(other$revokeMessages)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BanChatMember;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : ((Object)$untilDate).hashCode());
        Boolean $revokeMessages = this.getRevokeMessages();
        result = result * 59 + ($revokeMessages == null ? 43 : ((Object)$revokeMessages).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public Integer getUntilDate() {
        return this.untilDate;
    }

    @Generated
    public Boolean getRevokeMessages() {
        return this.revokeMessages;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="until_date")
    @Generated
    public void setUntilDate(Integer untilDate) {
        this.untilDate = untilDate;
    }

    @JsonProperty(value="revoke_messages")
    @Generated
    public void setRevokeMessages(Boolean revokeMessages) {
        this.revokeMessages = revokeMessages;
    }

    @Generated
    public String toString() {
        return "BanChatMember(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ", untilDate=" + this.getUntilDate() + ", revokeMessages=" + this.getRevokeMessages() + ")";
    }

    @Generated
    public BanChatMember(@NonNull String chatId, @NonNull Long userId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
    }

    @Generated
    public BanChatMember(@NonNull String chatId, @NonNull Long userId, Integer untilDate, Boolean revokeMessages) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.untilDate = untilDate;
        this.revokeMessages = revokeMessages;
    }

    public static abstract class BanChatMemberBuilder<C extends BanChatMember, B extends BanChatMemberBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Long userId;
        @Generated
        private Integer untilDate;
        @Generated
        private Boolean revokeMessages;

        public BanChatMemberBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="user_id")
        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @JsonProperty(value="until_date")
        @Generated
        public B untilDate(Integer untilDate) {
            this.untilDate = untilDate;
            return (B)this.self();
        }

        @JsonProperty(value="revoke_messages")
        @Generated
        public B revokeMessages(Boolean revokeMessages) {
            this.revokeMessages = revokeMessages;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BanChatMember.BanChatMemberBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", userId=" + this.userId + ", untilDate=" + this.untilDate + ", revokeMessages=" + this.revokeMessages + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class BanChatMemberBuilderImpl
    extends BanChatMemberBuilder<BanChatMember, BanChatMemberBuilderImpl> {
        @Generated
        private BanChatMemberBuilderImpl() {
        }

        @Override
        @Generated
        protected BanChatMemberBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BanChatMember build() {
            return new BanChatMember(this);
        }
    }
}

