/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SendGameBuilderImpl.class)
public class SendGame
extends BotApiMethodMessage {
    public static final String PATH = "sendGame";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String GAME_SHORT_NAME_FIELD = "game_short_name";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String REPLY_TO_MESSAGE_ID_FIELD = "reply_to_message_id";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String ALLOW_SENDING_WITHOUT_REPLY_FIELD = "allow_sending_without_reply";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    private static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String MESSAGE_EFFECT_ID_FIELD = "message_effect_id";
    private static final String ALLOW_PAID_BROADCAST_FIELD = "allow_paid_broadcast";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="game_short_name")
    @NonNull
    private String gameShortName;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="reply_parameters")
    private ReplyParameters replyParameters;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;
    @JsonProperty(value="message_effect_id")
    private String messageEffectId;
    @JsonProperty(value="allow_paid_broadcast")
    private Boolean allowPaidBroadcast;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = null;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (this.gameShortName.isEmpty()) {
            throw new TelegramApiValidationException("GameShortName parameter can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Generated
    protected SendGame(SendGameBuilder<?, ?> b) {
        super((BotApiMethodMessage.BotApiMethodMessageBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.gameShortName = b.gameShortName;
        if (this.gameShortName == null) {
            throw new NullPointerException("gameShortName is marked non-null but is null");
        }
        this.disableNotification = b.disableNotification;
        this.replyToMessageId = b.replyToMessageId;
        this.replyMarkup = b.replyMarkup;
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
        this.businessConnectionId = b.businessConnectionId;
        this.messageEffectId = b.messageEffectId;
        this.allowPaidBroadcast = b.allowPaidBroadcast;
    }

    @Generated
    public static SendGameBuilder<?, ?> builder() {
        return new SendGameBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendGame)) {
            return false;
        }
        SendGame other = (SendGame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        Boolean this$allowPaidBroadcast = this.getAllowPaidBroadcast();
        Boolean other$allowPaidBroadcast = other.getAllowPaidBroadcast();
        if (this$allowPaidBroadcast == null ? other$allowPaidBroadcast != null : !((Object)this$allowPaidBroadcast).equals(other$allowPaidBroadcast)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$gameShortName = this.getGameShortName();
        String other$gameShortName = other.getGameShortName();
        if (this$gameShortName == null ? other$gameShortName != null : !this$gameShortName.equals(other$gameShortName)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        String this$messageEffectId = this.getMessageEffectId();
        String other$messageEffectId = other.getMessageEffectId();
        return !(this$messageEffectId == null ? other$messageEffectId != null : !this$messageEffectId.equals(other$messageEffectId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendGame;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        Boolean $allowPaidBroadcast = this.getAllowPaidBroadcast();
        result = result * 59 + ($allowPaidBroadcast == null ? 43 : ((Object)$allowPaidBroadcast).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $gameShortName = this.getGameShortName();
        result = result * 59 + ($gameShortName == null ? 43 : $gameShortName.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        String $messageEffectId = this.getMessageEffectId();
        result = result * 59 + ($messageEffectId == null ? 43 : $messageEffectId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    @Generated
    public String getGameShortName() {
        return this.gameShortName;
    }

    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Generated
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Generated
    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Generated
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @Generated
    public String getMessageEffectId() {
        return this.messageEffectId;
    }

    @Generated
    public Boolean getAllowPaidBroadcast() {
        return this.allowPaidBroadcast;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="game_short_name")
    @Generated
    public void setGameShortName(@NonNull String gameShortName) {
        if (gameShortName == null) {
            throw new NullPointerException("gameShortName is marked non-null but is null");
        }
        this.gameShortName = gameShortName;
    }

    @JsonProperty(value="disable_notification")
    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="reply_to_message_id")
    @Generated
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="allow_sending_without_reply")
    @Generated
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="protect_content")
    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="reply_parameters")
    @Generated
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="message_effect_id")
    @Generated
    public void setMessageEffectId(String messageEffectId) {
        this.messageEffectId = messageEffectId;
    }

    @JsonProperty(value="allow_paid_broadcast")
    @Generated
    public void setAllowPaidBroadcast(Boolean allowPaidBroadcast) {
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    @Generated
    public String toString() {
        return "SendGame(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", gameShortName=" + this.getGameShortName() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ", businessConnectionId=" + this.getBusinessConnectionId() + ", messageEffectId=" + this.getMessageEffectId() + ", allowPaidBroadcast=" + this.getAllowPaidBroadcast() + ")";
    }

    @Generated
    public SendGame(@NonNull String chatId, @NonNull String gameShortName) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (gameShortName == null) {
            throw new NullPointerException("gameShortName is marked non-null but is null");
        }
        this.chatId = chatId;
        this.gameShortName = gameShortName;
    }

    @Generated
    public SendGame(@NonNull String chatId, Integer messageThreadId, @NonNull String gameShortName, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, Boolean allowSendingWithoutReply, Boolean protectContent, ReplyParameters replyParameters, String businessConnectionId, String messageEffectId, Boolean allowPaidBroadcast) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (gameShortName == null) {
            throw new NullPointerException("gameShortName is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.gameShortName = gameShortName;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
        this.businessConnectionId = businessConnectionId;
        this.messageEffectId = messageEffectId;
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    public static abstract class SendGameBuilder<C extends SendGame, B extends SendGameBuilder<C, B>>
    extends BotApiMethodMessage.BotApiMethodMessageBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private String gameShortName;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Integer replyToMessageId;
        @Generated
        private ReplyKeyboard replyMarkup;
        @Generated
        private Boolean allowSendingWithoutReply;
        @Generated
        private Boolean protectContent;
        @Generated
        private ReplyParameters replyParameters;
        @Generated
        private String businessConnectionId;
        @Generated
        private String messageEffectId;
        @Generated
        private Boolean allowPaidBroadcast;

        public SendGameBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="game_short_name")
        @Generated
        public B gameShortName(@NonNull String gameShortName) {
            if (gameShortName == null) {
                throw new NullPointerException("gameShortName is marked non-null but is null");
            }
            this.gameShortName = gameShortName;
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="reply_to_message_id")
        @Generated
        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="allow_sending_without_reply")
        @Generated
        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @JsonProperty(value="reply_parameters")
        @Generated
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @JsonProperty(value="message_effect_id")
        @Generated
        public B messageEffectId(String messageEffectId) {
            this.messageEffectId = messageEffectId;
            return (B)this.self();
        }

        @JsonProperty(value="allow_paid_broadcast")
        @Generated
        public B allowPaidBroadcast(Boolean allowPaidBroadcast) {
            this.allowPaidBroadcast = allowPaidBroadcast;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendGame.SendGameBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", gameShortName=" + this.gameShortName + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ", businessConnectionId=" + this.businessConnectionId + ", messageEffectId=" + this.messageEffectId + ", allowPaidBroadcast=" + this.allowPaidBroadcast + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendGameBuilderImpl
    extends SendGameBuilder<SendGame, SendGameBuilderImpl> {
        @Generated
        private SendGameBuilderImpl() {
        }

        @Override
        @Generated
        protected SendGameBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendGame build() {
            return new SendGame(this);
        }
    }
}

