/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.checklist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.api.objects.checklist.InputChecklist;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=EditMessageChecklistBuilderImpl.class)
public class EditMessageChecklist
extends BotApiMethodMessage {
    public static final String PATH = "editMessageChecklist";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String CHECKLIST_FIELD = "checklist";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    @JsonProperty(value="business_connection_id")
    @NonNull
    private String businessConnectionId;
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;
    @JsonProperty(value="checklist")
    @NonNull
    private InputChecklist checklist;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.businessConnectionId.isEmpty()) {
            throw new TelegramApiValidationException("BusinessConnectionId parameter can't be empty", this);
        }
        Validations.requiredChatId(this.chatId, this);
        this.checklist.validate();
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    @Generated
    protected EditMessageChecklist(EditMessageChecklistBuilder<?, ?> b) {
        super((BotApiMethodMessage.BotApiMethodMessageBuilder<?, ?>)b);
        this.businessConnectionId = b.businessConnectionId;
        if (this.businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageId = b.messageId;
        if (this.messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.checklist = b.checklist;
        if (this.checklist == null) {
            throw new NullPointerException("checklist is marked non-null but is null");
        }
        this.replyMarkup = b.replyMarkup;
    }

    @Generated
    public static EditMessageChecklistBuilder<?, ?> builder() {
        return new EditMessageChecklistBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditMessageChecklist)) {
            return false;
        }
        EditMessageChecklist other = (EditMessageChecklist)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputChecklist this$checklist = this.getChecklist();
        InputChecklist other$checklist = other.getChecklist();
        if (this$checklist == null ? other$checklist != null : !((Object)this$checklist).equals(other$checklist)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        return !(this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditMessageChecklist;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputChecklist $checklist = this.getChecklist();
        result = result * 59 + ($checklist == null ? 43 : ((Object)$checklist).hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @NonNull
    @Generated
    public InputChecklist getChecklist() {
        return this.checklist;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(@NonNull String businessConnectionId) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="checklist")
    @Generated
    public void setChecklist(@NonNull InputChecklist checklist) {
        if (checklist == null) {
            throw new NullPointerException("checklist is marked non-null but is null");
        }
        this.checklist = checklist;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @Generated
    public String toString() {
        return "EditMessageChecklist(businessConnectionId=" + this.getBusinessConnectionId() + ", chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", checklist=" + this.getChecklist() + ", replyMarkup=" + this.getReplyMarkup() + ")";
    }

    @Generated
    protected EditMessageChecklist() {
    }

    @Generated
    public EditMessageChecklist(@NonNull String businessConnectionId, @NonNull String chatId, @NonNull Integer messageId, @NonNull InputChecklist checklist) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (checklist == null) {
            throw new NullPointerException("checklist is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.chatId = chatId;
        this.messageId = messageId;
        this.checklist = checklist;
    }

    @Generated
    public EditMessageChecklist(@NonNull String businessConnectionId, @NonNull String chatId, @NonNull Integer messageId, @NonNull InputChecklist checklist, InlineKeyboardMarkup replyMarkup) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (checklist == null) {
            throw new NullPointerException("checklist is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.chatId = chatId;
        this.messageId = messageId;
        this.checklist = checklist;
        this.replyMarkup = replyMarkup;
    }

    public static abstract class EditMessageChecklistBuilder<C extends EditMessageChecklist, B extends EditMessageChecklistBuilder<C, B>>
    extends BotApiMethodMessage.BotApiMethodMessageBuilder<C, B> {
        @Generated
        private String businessConnectionId;
        @Generated
        private String chatId;
        @Generated
        private Integer messageId;
        @Generated
        private InputChecklist checklist;
        @Generated
        private InlineKeyboardMarkup replyMarkup;

        public EditMessageChecklistBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(@NonNull String businessConnectionId) {
            if (businessConnectionId == null) {
                throw new NullPointerException("businessConnectionId is marked non-null but is null");
            }
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="checklist")
        @Generated
        public B checklist(@NonNull InputChecklist checklist) {
            if (checklist == null) {
                throw new NullPointerException("checklist is marked non-null but is null");
            }
            this.checklist = checklist;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EditMessageChecklist.EditMessageChecklistBuilder(super=" + super.toString() + ", businessConnectionId=" + this.businessConnectionId + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", checklist=" + this.checklist + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class EditMessageChecklistBuilderImpl
    extends EditMessageChecklistBuilder<EditMessageChecklist, EditMessageChecklistBuilderImpl> {
        @Generated
        private EditMessageChecklistBuilderImpl() {
        }

        @Override
        @Generated
        protected EditMessageChecklistBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EditMessageChecklist build() {
            return new EditMessageChecklist(this);
        }
    }
}

