/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.starter;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.telegram.telegrambots.TelegramBotsApi;
import org.telegram.telegrambots.exceptions.TelegramApiException;
import org.telegram.telegrambots.generics.LongPollingBot;
import org.telegram.telegrambots.generics.WebhookBot;

@Configuration
public class TelegramBotStarterConfiguration
implements CommandLineRunner {
    private final List<LongPollingBot> longPollingBots;
    private final List<WebhookBot> webHookBots;
    @Autowired
    private TelegramBotsApi telegramBotsApi;

    public TelegramBotStarterConfiguration(List<LongPollingBot> longPollingBots, List<WebhookBot> webHookBots) {
        this.longPollingBots = longPollingBots;
        this.webHookBots = webHookBots;
    }

    public void run(String ... args) {
        try {
            for (LongPollingBot longPollingBot : this.longPollingBots) {
                this.telegramBotsApi.registerBot(longPollingBot);
            }
            for (WebhookBot webhookBot : this.webHookBots) {
                this.telegramBotsApi.registerBot(webhookBot);
            }
        }
        catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={TelegramBotsApi.class})
    public TelegramBotsApi telegramBotsApi() {
        return new TelegramBotsApi();
    }
}

