/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.starter;

import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.meta.generics.WebhookBot;

public class TelegramBotInitializer
implements InitializingBean {
    private final TelegramBotsApi telegramBotsApi;
    private final List<LongPollingBot> longPollingBots;
    private final List<WebhookBot> webHookBots;

    public TelegramBotInitializer(TelegramBotsApi telegramBotsApi, List<LongPollingBot> longPollingBots, List<WebhookBot> webHookBots) {
        Objects.requireNonNull(telegramBotsApi);
        Objects.requireNonNull(longPollingBots);
        Objects.requireNonNull(webHookBots);
        this.telegramBotsApi = telegramBotsApi;
        this.longPollingBots = longPollingBots;
        this.webHookBots = webHookBots;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            for (LongPollingBot longPollingBot : this.longPollingBots) {
                this.telegramBotsApi.registerBot(longPollingBot);
            }
            for (WebhookBot webhookBot : this.webHookBots) {
                this.telegramBotsApi.registerBot(webhookBot);
            }
        }
        catch (TelegramApiException e) {
            throw new RuntimeException(e);
        }
    }
}

