/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.starter;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.meta.generics.WebhookBot;
import org.telegram.telegrambots.starter.TelegramBotInitializer;

@Configuration
@ConditionalOnProperty(prefix="telegrambots", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class TelegramBotStarterConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={TelegramBotsApi.class})
    public TelegramBotsApi telegramBotsApi() {
        return new TelegramBotsApi();
    }

    @Bean
    @ConditionalOnMissingBean
    public TelegramBotInitializer telegramBotInitializer(TelegramBotsApi telegramBotsApi, ObjectProvider<List<LongPollingBot>> longPollingBots, ObjectProvider<List<WebhookBot>> webHookBots) {
        return new TelegramBotInitializer(telegramBotsApi, (List)longPollingBots.getIfAvailable(Collections::emptyList), (List)webHookBots.getIfAvailable(Collections::emptyList));
    }
}

