/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.webhook;

import java.io.File;
import lombok.Generated;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public class WebhookOptions {
    private Integer port;
    private Boolean enableRequestLogging;
    private Boolean useHttps;
    private String keyStorePath;
    private String keyStorePassword;

    public void validate() throws TelegramApiException {
        File file;
        if (!(!this.useHttps.booleanValue() || (file = new File(this.keyStorePath)).exists() && file.canRead())) {
            throw new TelegramApiException("Can't find or access server keystore file.");
        }
    }

    @Generated
    private static Integer $default$port() {
        return 9091;
    }

    @Generated
    private static Boolean $default$enableRequestLogging() {
        return false;
    }

    @Generated
    private static Boolean $default$useHttps() {
        return false;
    }

    @Generated
    public static WebhookOptionsBuilder builder() {
        return new WebhookOptionsBuilder();
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Boolean getEnableRequestLogging() {
        return this.enableRequestLogging;
    }

    @Generated
    public Boolean getUseHttps() {
        return this.useHttps;
    }

    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Generated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setEnableRequestLogging(Boolean enableRequestLogging) {
        this.enableRequestLogging = enableRequestLogging;
    }

    @Generated
    public void setUseHttps(Boolean useHttps) {
        this.useHttps = useHttps;
    }

    @Generated
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @Generated
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookOptions)) {
            return false;
        }
        WebhookOptions other = (WebhookOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$enableRequestLogging = this.getEnableRequestLogging();
        Boolean other$enableRequestLogging = other.getEnableRequestLogging();
        if (this$enableRequestLogging == null ? other$enableRequestLogging != null : !((Object)this$enableRequestLogging).equals(other$enableRequestLogging)) {
            return false;
        }
        Boolean this$useHttps = this.getUseHttps();
        Boolean other$useHttps = other.getUseHttps();
        if (this$useHttps == null ? other$useHttps != null : !((Object)this$useHttps).equals(other$useHttps)) {
            return false;
        }
        String this$keyStorePath = this.getKeyStorePath();
        String other$keyStorePath = other.getKeyStorePath();
        if (this$keyStorePath == null ? other$keyStorePath != null : !this$keyStorePath.equals(other$keyStorePath)) {
            return false;
        }
        String this$keyStorePassword = this.getKeyStorePassword();
        String other$keyStorePassword = other.getKeyStorePassword();
        return !(this$keyStorePassword == null ? other$keyStorePassword != null : !this$keyStorePassword.equals(other$keyStorePassword));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebhookOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $enableRequestLogging = this.getEnableRequestLogging();
        result = result * 59 + ($enableRequestLogging == null ? 43 : ((Object)$enableRequestLogging).hashCode());
        Boolean $useHttps = this.getUseHttps();
        result = result * 59 + ($useHttps == null ? 43 : ((Object)$useHttps).hashCode());
        String $keyStorePath = this.getKeyStorePath();
        result = result * 59 + ($keyStorePath == null ? 43 : $keyStorePath.hashCode());
        String $keyStorePassword = this.getKeyStorePassword();
        result = result * 59 + ($keyStorePassword == null ? 43 : $keyStorePassword.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WebhookOptions(port=" + this.getPort() + ", enableRequestLogging=" + this.getEnableRequestLogging() + ", useHttps=" + this.getUseHttps() + ", keyStorePath=" + this.getKeyStorePath() + ", keyStorePassword=" + this.getKeyStorePassword() + ")";
    }

    @Generated
    public WebhookOptions(Integer port, Boolean enableRequestLogging, Boolean useHttps, String keyStorePath, String keyStorePassword) {
        this.port = port;
        this.enableRequestLogging = enableRequestLogging;
        this.useHttps = useHttps;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
    }

    @Generated
    public WebhookOptions() {
        this.port = WebhookOptions.$default$port();
        this.enableRequestLogging = WebhookOptions.$default$enableRequestLogging();
        this.useHttps = WebhookOptions.$default$useHttps();
    }

    @Generated
    public static class WebhookOptionsBuilder {
        @Generated
        private boolean port$set;
        @Generated
        private Integer port$value;
        @Generated
        private boolean enableRequestLogging$set;
        @Generated
        private Boolean enableRequestLogging$value;
        @Generated
        private boolean useHttps$set;
        @Generated
        private Boolean useHttps$value;
        @Generated
        private String keyStorePath;
        @Generated
        private String keyStorePassword;

        @Generated
        WebhookOptionsBuilder() {
        }

        @Generated
        public WebhookOptionsBuilder port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        @Generated
        public WebhookOptionsBuilder enableRequestLogging(Boolean enableRequestLogging) {
            this.enableRequestLogging$value = enableRequestLogging;
            this.enableRequestLogging$set = true;
            return this;
        }

        @Generated
        public WebhookOptionsBuilder useHttps(Boolean useHttps) {
            this.useHttps$value = useHttps;
            this.useHttps$set = true;
            return this;
        }

        @Generated
        public WebhookOptionsBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        @Generated
        public WebhookOptionsBuilder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        @Generated
        public WebhookOptions build() {
            Integer port$value = this.port$value;
            if (!this.port$set) {
                port$value = WebhookOptions.$default$port();
            }
            Boolean enableRequestLogging$value = this.enableRequestLogging$value;
            if (!this.enableRequestLogging$set) {
                enableRequestLogging$value = WebhookOptions.$default$enableRequestLogging();
            }
            Boolean useHttps$value = this.useHttps$value;
            if (!this.useHttps$set) {
                useHttps$value = WebhookOptions.$default$useHttps();
            }
            return new WebhookOptions(port$value, enableRequestLogging$value, useHttps$value, this.keyStorePath, this.keyStorePassword);
        }

        @Generated
        public String toString() {
            return "WebhookOptions.WebhookOptionsBuilder(port$value=" + this.port$value + ", enableRequestLogging$value=" + this.enableRequestLogging$value + ", useHttps$value=" + this.useHttps$value + ", keyStorePath=" + this.keyStorePath + ", keyStorePassword=" + this.keyStorePassword + ")";
        }
    }
}

