/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.container.grizzly2.servlet;

import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.servlet.Servlet;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;

public final class GrizzlyWebContainerFactory {
    private GrizzlyWebContainerFactory() {
    }

    public static HttpServer create(String u) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyWebContainerFactory.create(URI.create(u));
    }

    public static HttpServer create(String u, Map<String, String> initParams) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyWebContainerFactory.create(URI.create(u), initParams);
    }

    public static HttpServer create(URI u) throws IOException, IllegalArgumentException {
        return GrizzlyWebContainerFactory.create(u, ServletContainer.class);
    }

    public static HttpServer create(URI u, Map<String, String> initParams) throws IOException {
        return GrizzlyWebContainerFactory.create(u, ServletContainer.class, initParams);
    }

    public static HttpServer create(String u, Class<? extends Servlet> c) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyWebContainerFactory.create(URI.create(u), c);
    }

    public static HttpServer create(String u, Class<? extends Servlet> c, Map<String, String> initParams) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyWebContainerFactory.create(URI.create(u), c, initParams);
    }

    public static HttpServer create(URI u, Class<? extends Servlet> c) throws IOException {
        return GrizzlyWebContainerFactory.create(u, c, null);
    }

    public static HttpServer create(URI u, Class<? extends Servlet> c, Map<String, String> initParams) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String path = u.getPath();
        if (path == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ", must be non-null");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ", must be present");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ". must start with a '/'");
        }
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        WebappContext context = new WebappContext("GrizzlyContext", path);
        ServletRegistration registration = context.addServlet(c.getName(), c);
        registration.addMapping("");
        if (initParams == null) {
            registration.setInitParameter("com.sun.jersey.config.property.classpath", System.getProperty("java.class.path").replace(File.pathSeparatorChar, ';'));
        } else {
            registration.setInitParameters(initParams);
        }
        HttpServer server = GrizzlyServerFactory.createHttpServer(u);
        context.deploy(server);
        return server;
    }
}

