/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.telegram.telegrambots.bots.BotOptions;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.bots.TelegramWebhookBot;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.updatesreceivers.BotSession;
import org.telegram.telegrambots.updatesreceivers.Webhook;

public class TelegramBotsApi {
    private static final int SOCKET_TIMEOUT = 75000;
    private static final String webhookUrlFormat = "{0}callback/";
    private boolean useWebhook;
    private Webhook webhook;
    private String extrenalUrl;
    private String pathToCertificate;

    public TelegramBotsApi() {
    }

    public TelegramBotsApi(String keyStore, String keyStorePassword, String externalUrl, String internalUrl) throws TelegramApiRequestException {
        if (externalUrl == null || externalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter externalUrl can not be null or empty");
        }
        if (internalUrl == null || internalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter internalUrl can not be null or empty");
        }
        this.useWebhook = true;
        this.extrenalUrl = TelegramBotsApi.fixExternalUrl(externalUrl);
        this.webhook = new Webhook(keyStore, keyStorePassword, internalUrl);
        this.webhook.startServer();
    }

    public TelegramBotsApi(String keyStore, String keyStorePassword, String externalUrl, String internalUrl, String pathToCertificate) throws TelegramApiRequestException {
        if (externalUrl == null || externalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter externalUrl can not be null or empty");
        }
        if (internalUrl == null || internalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter internalUrl can not be null or empty");
        }
        this.useWebhook = true;
        this.extrenalUrl = TelegramBotsApi.fixExternalUrl(externalUrl);
        this.pathToCertificate = pathToCertificate;
        this.webhook = new Webhook(keyStore, keyStorePassword, internalUrl);
        this.webhook.startServer();
    }

    public BotSession registerBot(TelegramLongPollingBot bot) throws TelegramApiRequestException {
        this.setWebhook(bot.getBotToken(), null, bot.getOptions());
        return new BotSession(bot.getBotToken(), bot, bot.getOptions());
    }

    public void registerBot(TelegramWebhookBot bot) throws TelegramApiRequestException {
        if (this.useWebhook) {
            this.webhook.registerWebhook(bot);
            this.setWebhook(bot.getBotToken(), bot.getBotPath(), bot.getOptions());
        }
    }

    private static String fixExternalUrl(String externalUrl) {
        if (externalUrl != null && !externalUrl.endsWith("/")) {
            externalUrl = externalUrl + "/";
        }
        return MessageFormat.format(webhookUrlFormat, externalUrl);
    }

    private static void setWebhook(String webHookURL, String botToken, String publicCertificatePath, BotOptions options) throws TelegramApiRequestException {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().setSSLHostnameVerifier(new NoopHostnameVerifier()).build();){
            File certificate;
            String url = "https://api.telegram.org/bot" + botToken + "/" + "setwebhook";
            RequestConfig.Builder configBuilder = RequestConfig.copy(RequestConfig.custom().build()).setSocketTimeout(75000).setConnectTimeout(75000).setConnectionRequestTimeout(75000);
            if (options.hasProxy()) {
                configBuilder.setProxy(new HttpHost(options.getProxyHost(), options.getProxyPort()));
            }
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(configBuilder.build());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("url", webHookURL);
            if (publicCertificatePath != null && (certificate = new File(publicCertificatePath)).exists()) {
                builder.addBinaryBody("certificate", certificate, ContentType.TEXT_PLAIN, certificate.getName());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            try (CloseableHttpResponse response = httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                String responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
                JSONObject jsonObject = new JSONObject(responseContent);
                if (!jsonObject.getBoolean("ok")) {
                    throw new TelegramApiRequestException(webHookURL == null ? "Error removing old webhook" : "Error setting webhook", jsonObject);
                }
            }
        }
        catch (JSONException e) {
            throw new TelegramApiRequestException("Error deserializing setWebhook method response", e);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error executing setWebook method", e);
        }
    }

    private void setWebhook(String botToken, String urlPath, BotOptions botOptions) throws TelegramApiRequestException {
        if (botToken == null) {
            throw new TelegramApiRequestException("Parameter botToken can not be null");
        }
        String completeExternalUrl = urlPath == null ? "" : this.extrenalUrl + urlPath;
        TelegramBotsApi.setWebhook(completeExternalUrl, botToken, this.pathToCertificate, botOptions);
    }
}

