/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class AnswerCallbackQuery
extends BotApiMethod<Boolean> {
    public static final String PATH = "answercallbackquery";
    private static final String CALLBACKQUERYID_FIELD = "callback_query_id";
    private static final String TEXT_FIELD = "text";
    private static final String SHOWALERT_FIELD = "show_alert";
    private static final String URL_FIELD = "url";
    @JsonProperty(value="callback_query_id")
    private String callbackQueryId;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="show_alert")
    private Boolean showAlert;
    @JsonProperty(value="url")
    private String url;

    public String getCallbackQueryId() {
        return this.callbackQueryId;
    }

    public void setCallbackQueryId(String callbackQueryId) {
        this.callbackQueryId = callbackQueryId;
    }

    public String getText() {
        return this.text;
    }

    public AnswerCallbackQuery setText(String text) {
        this.text = text;
        return this;
    }

    public Boolean getShowAlert() {
        return this.showAlert;
    }

    public AnswerCallbackQuery setShowAlert(Boolean showAlert) {
        this.showAlert = showAlert;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public AnswerCallbackQuery setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CALLBACKQUERYID_FIELD, this.callbackQueryId);
        if (this.text != null) {
            jsonObject.put(TEXT_FIELD, this.text);
        }
        if (this.showAlert != null) {
            jsonObject.put(SHOWALERT_FIELD, this.showAlert);
        }
        if (this.url != null) {
            jsonObject.put(URL_FIELD, this.url);
        }
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return answer.getBoolean("result");
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.callbackQueryId == null) {
            throw new TelegramApiValidationException("CallbackQueryId can't be null", this);
        }
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeStringField(CALLBACKQUERYID_FIELD, this.callbackQueryId);
        if (this.text != null) {
            gen.writeStringField(TEXT_FIELD, this.text);
        }
        if (this.showAlert != null) {
            gen.writeBooleanField(SHOWALERT_FIELD, this.showAlert);
        }
        if (this.url != null) {
            gen.writeStringField(URL_FIELD, this.url);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "AnswerCallbackQuery{callbackQueryId='" + this.callbackQueryId + '\'' + ", text='" + this.text + '\'' + ", showAlert=" + this.showAlert + ", url='" + this.url + '\'' + '}';
    }
}

