/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class AnswerInlineQuery
extends BotApiMethod<Boolean> {
    public static final String PATH = "answerInlineQuery";
    private static final String INLINEQUERYID_FIELD = "inline_query_id";
    private static final String RESULTS_FIELD = "results";
    private static final String CACHETIME_FIELD = "cache_time";
    private static final String ISPERSONAL_FIELD = "is_personal";
    private static final String NEXTOFFSET_FIELD = "next_offset";
    private static final String SWITCH_PM_TEXT_FIELD = "switch_pm_text";
    private static final String SWITCH_PM_PARAMETER_FIELD = "switch_pm_parameter";
    private String inlineQueryId;
    private List<InlineQueryResult> results;
    private Integer cacheTime;
    private Boolean isPersonal;
    private String nextOffset;
    private String switchPmText;
    private String switchPmParameter;

    public String getInlineQueryId() {
        return this.inlineQueryId;
    }

    public AnswerInlineQuery setInlineQueryId(String inlineQueryId) {
        this.inlineQueryId = inlineQueryId;
        return this;
    }

    public List<InlineQueryResult> getResults() {
        return this.results;
    }

    public AnswerInlineQuery setResults(List<InlineQueryResult> results) {
        this.results = results;
        return this;
    }

    public Integer getCacheTime() {
        return this.cacheTime;
    }

    public AnswerInlineQuery setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
        return this;
    }

    public Boolean getPersonal() {
        return this.isPersonal;
    }

    public AnswerInlineQuery setPersonal(Boolean personal) {
        this.isPersonal = personal;
        return this;
    }

    public String getNextOffset() {
        return this.nextOffset;
    }

    public AnswerInlineQuery setNextOffset(String nextOffset) {
        this.nextOffset = nextOffset;
        return this;
    }

    public String getSwitchPmText() {
        return this.switchPmText;
    }

    public AnswerInlineQuery setSwitchPmText(String switchPmText) {
        this.switchPmText = switchPmText;
        return this;
    }

    public String getSwitchPmParameter() {
        return this.switchPmParameter;
    }

    public AnswerInlineQuery setSwitchPmParameter(String switchPmParameter) {
        this.switchPmParameter = switchPmParameter;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineQueryId == null) {
            throw new TelegramApiValidationException("InlineQueryId can't be empty", this);
        }
        if (this.results == null) {
            throw new TelegramApiValidationException("Results array can't be null", this);
        }
        for (InlineQueryResult result : this.results) {
            result.validate();
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(INLINEQUERYID_FIELD, this.inlineQueryId);
        JSONArray JSONResults = new JSONArray();
        for (InlineQueryResult result : this.results) {
            JSONResults.put(result.toJson());
        }
        jsonObject.put(RESULTS_FIELD, JSONResults);
        if (this.cacheTime != null) {
            jsonObject.put(CACHETIME_FIELD, this.cacheTime);
        }
        if (this.isPersonal != null) {
            jsonObject.put(ISPERSONAL_FIELD, this.isPersonal);
        }
        if (this.nextOffset != null) {
            jsonObject.put(NEXTOFFSET_FIELD, this.nextOffset);
        }
        if (this.switchPmText != null) {
            jsonObject.put(SWITCH_PM_TEXT_FIELD, this.switchPmText);
        }
        if (this.switchPmParameter != null) {
            jsonObject.put(SWITCH_PM_PARAMETER_FIELD, this.switchPmParameter);
        }
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return answer.getBoolean("result");
        }
        return null;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeArrayFieldStart(RESULTS_FIELD);
        for (InlineQueryResult result : this.results) {
            gen.writeObject(result);
        }
        gen.writeEndArray();
        if (this.cacheTime != null) {
            gen.writeNumberField(CACHETIME_FIELD, this.cacheTime);
        }
        if (this.isPersonal != null) {
            gen.writeBooleanField(ISPERSONAL_FIELD, this.isPersonal);
        }
        if (this.nextOffset != null) {
            gen.writeStringField(NEXTOFFSET_FIELD, this.nextOffset);
        }
        if (this.switchPmText != null) {
            gen.writeStringField(SWITCH_PM_TEXT_FIELD, this.switchPmText);
        }
        if (this.switchPmParameter != null) {
            gen.writeStringField(SWITCH_PM_PARAMETER_FIELD, this.switchPmParameter);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "AnswerInlineQuery{inlineQueryId='" + this.inlineQueryId + '\'' + ", results=" + this.results + ", cacheTime=" + this.cacheTime + ", isPersonal=" + this.isPersonal + ", switchPmText=" + this.switchPmText + ", switchPmParameter=" + this.switchPmParameter + ", nextOffset='" + this.nextOffset + '\'' + '}';
    }
}

